/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.CreateContainerBasicOptions;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateContainerOptionsBuilder;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.service.MQServiceImpl;

@Command(name="mq-create", scope="fabric", description="Create a new broker")
public class MQCreate
extends FabricCommand {
    @Argument(index=0, required=true, description="Broker name")
    protected String name = null;
    @Option(name="--config", description="Configuration to use")
    protected String config;
    @Option(name="--data", description="Data directory for the broker")
    protected String data;
    @Option(name="--group", description="Broker group")
    protected String group;
    @Option(name="--networks", description="Broker networks")
    protected String networks;
    @Option(name="--version", description="The version id in the registry")
    protected String version = "1.0";
    @Option(name="--create-container", multiValued=false, required=false, description="Comma separated list of containers to create with mq profile")
    protected String create;
    @Option(name="--assign-container", multiValued=false, required=false, description="Assign this mq profile to the following containers")
    protected String assign;

    protected Object doExecute() throws Exception {
        MQServiceImpl service = new MQServiceImpl(this.fabricService);
        HashMap<String, String> configuration = new HashMap<String, String>();
        if (this.data == null) {
            this.data = System.getProperty("karaf.base") + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + this.name;
        }
        configuration.put("data", this.data);
        if (this.config != null) {
            configuration.put("config", service.getConfig(this.version, this.config));
        }
        if (this.group != null) {
            configuration.put("group", this.group);
        }
        if (this.networks != null) {
            configuration.put("network", this.networks);
        }
        Profile profile = service.createMQProfile(this.version, this.name, configuration);
        System.out.println("MQ profile " + profile.getId() + " ready");
        if (this.assign != null) {
            String[] assignContainers;
            for (String containerName : assignContainers = this.assign.split(",")) {
                try {
                    Container container = this.fabricService.getContainer(containerName);
                    if (container == null) {
                        System.out.println("Failed to assign profile to " + containerName + ": profile doesn't exists");
                        continue;
                    }
                    HashSet<Profile> profiles = new HashSet<Profile>(Arrays.asList(container.getProfiles()));
                    profiles.add(profile);
                    container.setProfiles(profiles.toArray(new Profile[profiles.size()]));
                    System.out.println("Profile successfully assigned to " + containerName);
                }
                catch (Exception e) {
                    System.out.println("Failed to assign profile to " + containerName + ": " + e.getMessage());
                }
            }
        }
        if (this.create != null) {
            String[] createContainers;
            for (String url : createContainers = this.create.split(",")) {
                CreateContainerMetadata[] metadatas;
                String type = null;
                String parent = "root";
                String name = url;
                if (url.contains("://")) {
                    URI uri = new URI(url);
                    type = uri.getScheme();
                    parent = null;
                    name = uri.getHost();
                } else {
                    type = "child";
                    url = "child://root";
                }
                CreateContainerBasicOptions args = CreateContainerOptionsBuilder.type((String)type).name(name).parent(parent).number(1).ensembleServer(false).providerUri(url).proxyUri(this.fabricService.getMavenRepoURI()).zookeeperUrl(this.fabricService.getZookeeperUrl());
                for (CreateContainerMetadata metadata : metadatas = this.fabricService.createContainers((CreateContainerOptions)args)) {
                    if (metadata.isSuccess()) {
                        Container child = metadata.getContainer();
                        child.setProfiles(new Profile[]{profile});
                        System.out.println("Successfully created container " + metadata.getContainerName());
                        continue;
                    }
                    System.out.println("Failed to create container " + metadata.getContainerName() + ": " + metadata.getFailure().getMessage());
                }
            }
        }
        return null;
    }
}

