/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.boot.commands.support.EnsembleCommandSupport;

@Command(name="ensemble-add", scope="fabric", description="Extend the current fabric ensemble by converting the specified containers into ensemble servers", detailedDescription="classpath:ensembleAdd.txt")
public class EnsembleAdd
extends EnsembleCommandSupport {
    @Argument(required=true, multiValued=true, description="List of containers to be added")
    private List<String> containers;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        if (this.containers != null && !this.containers.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Adding containers:");
            for (String container : this.containers) {
                builder.append(" ").append(container);
            }
            builder.append(" to the ensemble. This may take a while.");
            System.out.println(builder.toString());
            this.service.addToCluster(this.containers);
        }
        return null;
    }
}

