/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

@Command(name="container-resolver-set", scope="fabric", description="Apply the specified resolver policy to the specified container or containers", detailedDescription="classpath:containerResolverSet.txt")
public class ContainerResolverSet
extends FabricCommand {
    @Option(name="--all", description="Apply the resolver policy to all containers in the fabric.")
    private boolean all;
    @Option(name="--container", description="Apply the resolver policy to the specified container.", required=false, multiValued=true)
    private List<String> containerIds;
    @Argument(index=0, name="resolver", description="The resolver policy to set on the specified container(s). Possible values are: localip, localhostname, publicip, publichostname, manualip.", required=true, multiValued=false)
    private String resolver;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        if (this.containerIds == null || this.containerIds.isEmpty()) {
            if (this.all) {
                this.containerIds = new ArrayList<String>();
                for (Container container : this.fabricService.getContainers()) {
                    this.containerIds.add(container.getId());
                }
            } else {
                this.containerIds = Arrays.asList(this.fabricService.getCurrentContainer().getId());
            }
        } else if (this.all) {
            throw new IllegalArgumentException("Can not use --all with a list of containers simultaneously");
        }
        for (String containerId : this.containerIds) {
            Container container = this.fabricService.getContainer(containerId);
            container.setResolver(this.resolver);
        }
        return null;
    }
}

