/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.PrintStream;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.commands.support.CommandUtils;

@Command(name="container-list", scope="fabric", description="List the containers in the current fabric")
public class ContainerList
extends FabricCommand {
    static final String FORMAT = "%-30s %-9s %-7s %-30s %s";
    static final String VERBOSE_FORMAT = "%-20s %-9s %-7s %-30s  %-30s %-90s %s";
    static final String[] HEADERS = new String[]{"[id]", "[version]", "[alive]", "[profiles]", "[provision status]"};
    static final String[] VERBOSE_HEADERS = new String[]{"[id]", "[version]", "[alive]", "[profiles]", "[ssh url]", "[jmx url]", "[provision status]"};
    @Option(name="--version", description="Optional version to use as filter")
    private String version;
    @Option(name="-v", aliases={"--verbose"}, description="Flag for verbose output", multiValued=false, required=false)
    private boolean verbose;
    @Argument(index=0, name="filter", description="Filter by container ID or by profile name. When a profile name is specified, only the containers with that profile are listed.", required=false, multiValued=false)
    private String filter = null;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        Container[] containers = this.fabricService.getContainers();
        containers = CommandUtils.filterContainers(containers, this.filter);
        containers = CommandUtils.sortContainers(containers);
        Version ver = null;
        if (this.version != null) {
            ver = this.fabricService.getVersion(this.version);
        }
        if (this.verbose) {
            this.printContainersVerbose(containers, ver, System.out);
        } else {
            this.printContainers(containers, ver, System.out);
        }
        return null;
    }

    protected void printContainers(Container[] containers, Version version, PrintStream out) {
        out.println(String.format(FORMAT, HEADERS));
        for (Container container : containers) {
            if (!CommandUtils.matchVersion(container, version)) continue;
            String indent = "";
            Container c = container;
            while (!c.isRoot()) {
                indent = indent + "  ";
                c = c.getParent();
            }
            String marker = "";
            if (container.getId().equals(this.fabricService.getCurrentContainer().getId())) {
                marker = "*";
            }
            out.println(String.format(FORMAT, indent + container.getId() + marker, container.getVersion().getName(), container.isAlive(), this.toString(container.getProfiles()), CommandUtils.status(container)));
        }
    }

    protected void printContainersVerbose(Container[] containers, Version version, PrintStream out) {
        out.println(String.format(VERBOSE_FORMAT, VERBOSE_HEADERS));
        for (Container container : containers) {
            if (!CommandUtils.matchVersion(container, version)) continue;
            String indent = "";
            Container c = container;
            while (!c.isRoot()) {
                indent = indent + "  ";
                c = c.getParent();
            }
            String marker = "";
            if (container.getId().equals(this.fabricService.getCurrentContainer().getId())) {
                marker = "*";
            }
            out.println(String.format(VERBOSE_FORMAT, indent + container.getId() + marker, container.getVersion().getName(), container.isAlive(), this.toString(container.getProfiles()), container.getSshUrl(), container.getJmxUrl(), CommandUtils.status(container)));
        }
    }
}

