/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.CreateContainerBasicOptions;
import org.fusesource.fabric.api.CreateContainerChildOptions;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateContainerOptionsBuilder;
import org.fusesource.fabric.boot.commands.support.ContainerCreateSupport;

@Command(name="container-create-child", scope="fabric", description="Creates one or more child containers", detailedDescription="classpath:containerCreateChild.txt")
public class ContainerCreateChild
extends ContainerCreateSupport {
    @Argument(index=0, required=true, description="Parent containers ID")
    protected String parent;
    @Argument(index=1, required=true, description="The name of the containers to be created. When creating multiple containers it serves as a prefix")
    protected String name;
    @Argument(index=2, required=false, description="The number of containers that should be created")
    protected int number = 1;

    protected Object doExecute() throws Exception {
        this.preCreateContainer(this.name);
        String url = "child://" + this.parent;
        CreateContainerBasicOptions options = ((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)CreateContainerOptionsBuilder.child().name(this.name)).parent(this.parent)).providerUri(url)).resolver(this.resolver)).ensembleServer(this.isEnsembleServer.booleanValue())).number(this.number)).zookeeperUrl(this.fabricService.getZookeeperUrl())).jvmOpts(this.jvmOpts);
        CreateContainerMetadata[] metadatas = this.fabricService.createContainers((CreateContainerOptions)options);
        this.displayContainers(metadatas);
        this.postCreateContainers(metadatas);
        return null;
    }

    @Override
    protected void preCreateContainer(String name) {
        super.preCreateContainer(name);
        if (this.number < 1 || this.number > 99) {
            throw new IllegalArgumentException("The number of containers must be between 1 and 99.");
        }
        if (this.isEnsembleServer.booleanValue() && this.number > 1) {
            throw new IllegalArgumentException("Can not create a new ZooKeeper ensemble on multiple containers.  Create the containers first and then use the fabric:create command instead.");
        }
    }
}

