/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Service;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.fabric.camel.DefaultLoadBalancerFactory;
import org.fusesource.fabric.camel.FabricLocatorEndpoint;
import org.fusesource.fabric.camel.FabricPublisherEndpoint;
import org.fusesource.fabric.camel.LoadBalancerFactory;
import org.fusesource.fabric.camel.ZKComponentSupport;
import org.fusesource.fabric.groups.Group;
import org.fusesource.fabric.groups.ZooKeeperGroupFactory;
import org.linkedin.zookeeper.client.IZKClient;

public class FabricComponent
extends ZKComponentSupport {
    private static final transient Log LOG = LogFactory.getLog(FabricComponent.class);
    private String zkRoot = "/fabric/registry/camel/endpoints";
    private LoadBalancerFactory loadBalancerFactory = new DefaultLoadBalancerFactory();
    private ProducerCache producerCache;
    private int cacheSize = 1000;

    public String getZkRoot() {
        return this.zkRoot;
    }

    public void setZkRoot(String zkRoot) {
        this.zkRoot = zkRoot;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public ProducerCache getProducerCache() {
        return this.producerCache;
    }

    public void setProducerCache(ProducerCache producerCache) {
        this.producerCache = producerCache;
    }

    public LoadBalancerFactory getLoadBalancerFactory() {
        return this.loadBalancerFactory;
    }

    public void setLoadBalancerFactory(LoadBalancerFactory loadBalancerFactory) {
        this.loadBalancerFactory = loadBalancerFactory;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache((Object)this, this.getCamelContext(), this.cacheSize);
        }
        ServiceHelper.startService((Service)this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.producerCache);
        super.doStop();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        int idx = remaining.indexOf(58);
        if (idx > 0) {
            String name = remaining.substring(0, idx);
            String fabricPath = this.getFabricPath(name);
            String childUri = this.replaceAnyIpAddress(remaining.substring(idx + 1));
            Group group = ZooKeeperGroupFactory.create((IZKClient)this.getZkClient(), (String)fabricPath, (List)this.accessControlList);
            return new FabricPublisherEndpoint(uri, this, group, childUri);
        }
        String fabricPath = this.getFabricPath(remaining);
        Group group = ZooKeeperGroupFactory.create((IZKClient)this.getZkClient(), (String)fabricPath, (List)this.accessControlList);
        return new FabricLocatorEndpoint(uri, this, group);
    }

    protected String getFabricPath(String name) {
        String path = name;
        if (ObjectHelper.isNotEmpty((Object)this.zkRoot)) {
            path = this.zkRoot + "/" + name;
        }
        return path;
    }

    protected String replaceAnyIpAddress(String uri) {
        String result = uri;
        if (uri.indexOf("0.0.0.0") > 0) {
            try {
                String hostAddress = InetAddress.getLocalHost().getHostAddress();
                result = uri.replace("0.0.0.0", hostAddress);
            }
            catch (UnknownHostException ex) {
                LOG.warn((Object)"Cannot find the local host name, due to {0}", (Throwable)ex);
            }
        }
        return result;
    }
}

