/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.codehaus.jackson.annotate.JsonProperty;
import org.fusesource.fabric.groups.ChangeListener;
import org.fusesource.fabric.groups.ClusteredSingleton;
import org.fusesource.fabric.groups.Group;
import org.fusesource.fabric.groups.NodeState;
import org.fusesource.fabric.groups.ZooKeeperGroupFactory;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.ZKClient;

public class ClusteredSingletonLifecycleStrategy
implements LifecycleStrategy {
    public static Log LOG = LogFactory.getLog(ClusteredSingletonLifecycleStrategy.class);
    Group group;
    String groupName;
    String id;
    volatile CamelContext camelContext;
    final AtomicBoolean started = new AtomicBoolean();
    IZKClient zkClient;
    boolean managedZkClient;
    ClusteredSingleton<CamelNode> singleton = new ClusteredSingleton(CamelNode.class);
    public List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;

    static void info(String msg, Object ... args) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)String.format(msg, args));
        }
    }

    CamelNode createState() {
        CamelNode state = new CamelNode();
        state.id = this.id;
        state.container = System.getProperty("karaf.name");
        state.started = this.started.get();
        return state;
    }

    public void start() throws Exception {
        if (this.zkClient == null) {
            this.managedZkClient = true;
            ZKClient client = new ZKClient(System.getProperty("zookeeper.url", "localhost:2181"), Timespan.parse((String)"10s"), null);
            client.start();
            client.waitForStart();
            this.zkClient = client;
        } else {
            this.managedZkClient = false;
        }
        this.group = ZooKeeperGroupFactory.create((IZKClient)this.zkClient, (String)("/fabric/camel-clusters/" + this.groupName), this.acl);
        this.singleton.start(this.group);
        this.singleton.join((NodeState)this.createState());
        ClusteredSingletonLifecycleStrategy.info("Camel context %s is waiting to become the master", this.id);
        this.singleton.add(new ChangeListener(){

            public void changed() {
                if (ClusteredSingletonLifecycleStrategy.this.singleton.isMaster()) {
                    if (ClusteredSingletonLifecycleStrategy.this.started.compareAndSet(false, true)) {
                        ClusteredSingletonLifecycleStrategy.info("Camel context %s is now the master, starting the context.", ClusteredSingletonLifecycleStrategy.this.id);
                        try {
                            ClusteredSingletonLifecycleStrategy.this.camelContext.start();
                            ClusteredSingletonLifecycleStrategy.this.singleton.update((NodeState)ClusteredSingletonLifecycleStrategy.this.createState());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (ClusteredSingletonLifecycleStrategy.this.started.compareAndSet(true, false)) {
                    ClusteredSingletonLifecycleStrategy.info("Camel context %s is now a slave, stopping the context.", ClusteredSingletonLifecycleStrategy.this.id);
                    try {
                        ClusteredSingletonLifecycleStrategy.this.camelContext.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void connected() {
                this.changed();
            }

            public void disconnected() {
                this.changed();
            }
        });
    }

    public void stop() {
        try {
            this.group.close();
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        if (this.managedZkClient) {
            try {
                this.zkClient.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.zkClient = null;
        }
    }

    public void onContextStart(CamelContext camelContext) throws VetoCamelContextStartException {
        this.camelContext = camelContext;
        if (!this.started.get()) {
            throw new VetoCamelContextStartException("Do not start him! and don't rethrow", camelContext);
        }
    }

    public void onContextStop(CamelContext camelContext) {
    }

    public void onComponentAdd(String s, Component component) {
    }

    public void onComponentRemove(String s, Component component) {
    }

    public void onEndpointAdd(Endpoint endpoint) {
    }

    public void onEndpointRemove(Endpoint endpoint) {
    }

    public void onServiceAdd(CamelContext camelContext, Service service, Route route) {
    }

    public void onServiceRemove(CamelContext camelContext, Service service, Route route) {
    }

    public void onRoutesAdd(Collection<Route> routes) {
    }

    public void onRoutesRemove(Collection<Route> routes) {
    }

    public void onRouteContextCreate(RouteContext routeContext) {
    }

    public void onErrorHandlerAdd(RouteContext routeContext, Processor processor, ErrorHandlerFactory errorHandlerFactory) {
    }

    public void onErrorHandlerAdd(RouteContext routeContext, Processor processor, ErrorHandlerBuilder errorHandlerBuilder) {
    }

    public void onErrorHandlerRemove(RouteContext routeContext, Processor errorHandler, ErrorHandlerFactory errorHandlerBuilder) {
    }

    public void onThreadPoolAdd(CamelContext camelContext, ThreadPoolExecutor threadPoolExecutor, String s, String s1, String s2, String s3) {
    }

    public void onThreadPoolRemove(CamelContext camelContext, ThreadPoolExecutor threadPoolExecutor) {
    }

    public List<ACL> getAcl() {
        return this.acl;
    }

    public void setAcl(List<ACL> acl) {
        this.acl = acl;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IZKClient getZkClient() {
        return this.zkClient;
    }

    public void setZkClient(IZKClient zkClient) {
        this.zkClient = zkClient;
    }

    static class CamelNode
    implements NodeState {
        @JsonProperty
        String id;
        @JsonProperty
        String container;
        @JsonProperty
        Boolean started;

        CamelNode() {
        }

        public String id() {
            return this.id;
        }
    }
}

