/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel;

import java.util.List;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.fusesource.fabric.camel.MasterComponent;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.ZKClient;

public abstract class ZKComponentSupport
extends DefaultComponent {
    private static final transient Log LOG = LogFactory.getLog(MasterComponent.class);
    private IZKClient zkClient;
    protected List<ACL> accessControlList = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private boolean shouldCloseZkClient = false;
    private long maximumConnectionTimeout = 10000L;
    private long connectionRetryTime = 100L;

    public IZKClient getZkClient() {
        return this.zkClient;
    }

    public void setZkClient(IZKClient zkClient) {
        this.zkClient = zkClient;
    }

    public boolean isShouldCloseZkClient() {
        return this.shouldCloseZkClient;
    }

    public void setShouldCloseZkClient(boolean shouldCloseZkClient) {
        this.shouldCloseZkClient = shouldCloseZkClient;
    }

    public List<ACL> getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(List<ACL> accessControlList) {
        this.accessControlList = accessControlList;
    }

    public long getConnectionRetryTime() {
        return this.connectionRetryTime;
    }

    public void setConnectionRetryTime(long connectionRetryTime) {
        this.connectionRetryTime = connectionRetryTime;
    }

    public long getMaximumConnectionTimeout() {
        return this.maximumConnectionTimeout;
    }

    public void setMaximumConnectionTimeout(long maximumConnectionTimeout) {
        this.maximumConnectionTimeout = maximumConnectionTimeout;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.zkClient == null) {
            this.zkClient = (IZKClient)this.getCamelContext().getRegistry().lookup("zkClient");
            if (this.zkClient != null) {
                LOG.debug((Object)("IZKClient found in camel registry. " + this.zkClient));
            }
        }
        if (this.zkClient == null) {
            String connectString = System.getProperty("zookeeper.url", "localhost:2181");
            ZKClient client = new ZKClient(connectString, Timespan.parse((String)"10s"), null);
            LOG.debug((Object)("IZKClient not find in camel registry, creating new with connection " + connectString));
            this.zkClient = client;
            this.setShouldCloseZkClient(true);
        }
        if (this.zkClient instanceof ZKClient && !this.zkClient.isConnected()) {
            LOG.debug((Object)("Staring IZKClient " + this.zkClient));
            ((ZKClient)this.zkClient).start();
        }
        this.checkZkConnected();
    }

    protected void checkZkConnected() throws Exception {
        long start = System.currentTimeMillis();
        do {
            if (this.zkClient.isConnected()) {
                return;
            }
            try {
                Thread.sleep(this.getConnectionRetryTime());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < start + this.getMaximumConnectionTimeout());
        if (!this.zkClient.isConnected()) {
            throw new Exception("Could not connect to ZooKeeper " + this.zkClient + " at " + this.zkClient.getConnectString());
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.zkClient != null && this.isShouldCloseZkClient()) {
            this.zkClient.close();
        }
    }
}

