/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel.c24io;

import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.data.Element;
import biz.c24.io.api.data.ValidationException;
import biz.c24.io.api.transform.Transform;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.util.ObjectHelper;
import org.fusesource.fabric.camel.c24io.C24IOSource;

public class C24IOTransform
implements Processor {
    private Transform transform;

    public C24IOTransform(Transform transform) {
        this.transform = transform;
    }

    public static C24IOTransform transform(Class<?> transformType) {
        Transform transformer = (Transform)ObjectHelper.newInstance(transformType);
        return C24IOTransform.transform(transformer);
    }

    public static C24IOTransform transform(Transform transformer) {
        return new C24IOTransform(transformer);
    }

    public void process(Exchange exchange) throws Exception {
        Object[][] objects = null;
        ComplexDataObject dataObject = null;
        try {
            dataObject = (ComplexDataObject)exchange.getIn().getMandatoryBody(ComplexDataObject.class);
        }
        catch (InvalidPayloadException e1) {
            try {
                objects = (ComplexDataObject[][])exchange.getIn().getMandatoryBody(ComplexDataObject[][].class);
            }
            catch (InvalidPayloadException e2) {
                objects = this.getInBodyAsArray(exchange, (ComplexDataObject[][])objects);
            }
        }
        if (objects == null) {
            if (dataObject == null) {
                dataObject = this.unmarshalDataObject(exchange);
            }
            objects = new ComplexDataObject[][]{{dataObject}};
        }
        Object result = this.transform(objects);
        Message out = exchange.getOut();
        out.setBody(result);
    }

    private ComplexDataObject[][] getInBodyAsArray(Exchange exchange, ComplexDataObject[][] objects) {
        try {
            ComplexDataObject[] array = (ComplexDataObject[])exchange.getIn().getMandatoryBody(ComplexDataObject[].class);
            if (array != null) {
                objects = new ComplexDataObject[][]{array};
            }
        }
        catch (InvalidPayloadException invalidPayloadException) {
            // empty catch block
        }
        return objects;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    protected Object transform(Object[][] objects) throws ValidationException {
        Transform transformer = this.getTransform();
        Object[][] answer = transformer.transform(objects);
        return answer[0][0];
    }

    protected ComplexDataObject unmarshalDataObject(Exchange exchange) throws InvalidPayloadException, IOException {
        Transform transformer = this.getTransform();
        Element input = transformer.getInput(0);
        C24IOSource source = new C24IOSource(input);
        return source.parseDataObject(exchange);
    }
}

