/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel.c24io;

import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.data.Element;
import biz.c24.io.api.presentation.BinarySource;
import biz.c24.io.api.presentation.JavaClassSource;
import biz.c24.io.api.presentation.SAXSource;
import biz.c24.io.api.presentation.Source;
import biz.c24.io.api.presentation.TextualSource;
import biz.c24.io.api.presentation.XMLSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.fusesource.fabric.camel.c24io.C24IOHelper;

public class C24IOSource<T extends C24IOSource>
implements Processor {
    private Element element;
    private Source source;

    public C24IOSource() {
    }

    public C24IOSource(Element element) {
        this.element = element;
    }

    public static C24IOSource c24Source(String modelClassName) {
        try {
            Class elementType = ObjectHelper.loadClass((String)modelClassName);
            return C24IOSource.c24Source(elementType);
        }
        catch (RuntimeCamelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public static C24IOSource c24Source(Class<?> elementType) {
        Element element = C24IOHelper.getMandatoryElement(elementType);
        return C24IOSource.c24Source(element);
    }

    public static C24IOSource c24Source(Element element) {
        return new C24IOSource(element);
    }

    public void process(Exchange exchange) throws Exception {
        ComplexDataObject object = this.parseDataObject(exchange);
        Message out = exchange.getOut();
        out.setHeader("c24io.element", (Object)this.element);
        out.setBody((Object)object);
    }

    protected ComplexDataObject parseDataObject(Exchange exchange) throws InvalidPayloadException, IOException {
        Source source = this.getSource();
        Reader reader = (Reader)exchange.getIn().getBody(Reader.class);
        if (reader != null) {
            source.setReader(reader);
        } else {
            InputStream inStream = (InputStream)ExchangeHelper.getMandatoryInBody((Exchange)exchange, InputStream.class);
            source.setInputStream(inStream);
        }
        ComplexDataObject object = source.readObject(this.element);
        return object;
    }

    public static Element element(String modelClassName) {
        try {
            Class<?> elementType = Class.forName(modelClassName);
            return C24IOSource.element(elementType);
        }
        catch (RuntimeCamelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public static Element element(Class<?> elementType) {
        return C24IOHelper.getMandatoryElement(elementType);
    }

    public Element getElement() {
        return this.element;
    }

    public Source getSource() {
        if (this.source == null) {
            return this.getElement().getModel().source();
        }
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public T textSource() {
        this.setSource((Source)new TextualSource());
        return (T)this;
    }

    public T xmlSource() {
        this.setSource((Source)new XMLSource());
        return (T)this;
    }

    public T saxSource() {
        this.setSource((Source)new SAXSource());
        return (T)this;
    }

    public T binarySource() {
        this.setSource((Source)new BinarySource());
        return (T)this;
    }

    public T javaSource() {
        this.setSource((Source)new JavaClassSource());
        return (T)this;
    }
}

