/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel.c24io;

import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.data.ValidationException;
import biz.c24.io.api.presentation.BinarySink;
import biz.c24.io.api.presentation.JavaClassSink;
import biz.c24.io.api.presentation.SAXSink;
import biz.c24.io.api.presentation.Sink;
import biz.c24.io.api.presentation.TagValuePairSink;
import biz.c24.io.api.presentation.TextualSink;
import biz.c24.io.api.presentation.XMLSink;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.util.ExchangeHelper;
import org.fusesource.fabric.camel.c24io.C24IOSource;

public class C24IOSink
extends C24IOSource {
    private Sink sink;

    public C24IOSink() {
    }

    public C24IOSink(Sink sink) {
        this.sink = sink;
    }

    public static C24IOSink c24Sink() {
        return new C24IOSink();
    }

    public static C24IOSink c24Sink(Sink sink) {
        return new C24IOSink(sink);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        ComplexDataObject dataObject = this.unmarshalDataObject(exchange);
        dataObject = this.transformDataObject(exchange, dataObject);
        Sink s = this.getSink();
        if (s == null) {
            s = dataObject.getModel().sink();
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        s.setOutputStream((OutputStream)buffer);
        s.writeObject(dataObject);
        Message out = exchange.getOut();
        out.setHeader("c24io.sink", (Object)this.sink);
        out.setBody((Object)buffer.toByteArray());
    }

    public Sink getSink() {
        return this.sink;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public C24IOSink text() {
        this.setSink((Sink)new TextualSink());
        return this;
    }

    public C24IOSink binary() {
        this.setSink((Sink)new BinarySink());
        return this;
    }

    public C24IOSink xml() {
        this.setSink((Sink)new XMLSink());
        return this;
    }

    public C24IOSink sax() {
        this.setSink((Sink)new SAXSink());
        return this;
    }

    public C24IOSink tagValuePair() {
        this.setSink((Sink)new TagValuePairSink());
        return this;
    }

    public C24IOSink java() {
        this.setSink((Sink)new JavaClassSink());
        return this;
    }

    protected ComplexDataObject unmarshalDataObject(Exchange exchange) throws InvalidPayloadException, IOException {
        return (ComplexDataObject)ExchangeHelper.getMandatoryInBody((Exchange)exchange, ComplexDataObject.class);
    }

    protected ComplexDataObject transformDataObject(Exchange exchange, ComplexDataObject dataObject) throws ValidationException {
        return dataObject;
    }
}

