/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.boot.commands.support;

import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.zookeeper.IZKClient;

public class ContainerCompleter
implements Completer {
    protected FabricService fabricService;
    protected IZKClient zooKeeper;

    public int complete(String buffer, int cursor, List<String> candidates) {
        if (this.zooKeeper.isConnected()) {
            StringsCompleter delegate = new StringsCompleter();
            for (Container container : this.fabricService.getContainers()) {
                if (!this.apply(container)) continue;
                delegate.getStrings().add(container.getId());
            }
            return delegate.complete(buffer, cursor, candidates);
        }
        return 0;
    }

    public boolean apply(Container container) {
        return true;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }
}

