/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.boot.commands;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.boot.commands.support.EnsembleCommandSupport;

@Command(name="ensemble-create", scope="fabric", description="Create a new ZooKeeper ensemble", detailedDescription="classpath:ensembleCreate.txt")
public class EnsembleCreate
extends EnsembleCommandSupport {
    @Option(name="--clean", description="Clean local zookeeper cluster and configurations")
    private boolean clean;
    @Option(name="-n", aliases={"--non-managed"}, multiValued=false, description="Flag to keep the container non managed")
    private boolean nonManaged;
    @Argument(required=true, multiValued=true, description="List of containers")
    private List<String> containers;

    protected Object doExecute() throws Exception {
        if (this.clean) {
            this.service.clean();
        }
        if (this.nonManaged) {
            System.setProperty("agent.auto.start", "false");
        } else {
            System.setProperty("agent.auto.start", "true");
        }
        this.service.createCluster(this.containers);
        return null;
    }
}

