/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.boot.commands.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.api.ZooKeeperClusterService;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.osgi.framework.ServiceReference;

public abstract class ContainerCreateSupport
extends FabricCommand {
    @Option(name="--version", description="The version of the new container (must be an existing version). Defaults to the current default version.")
    protected String version;
    @Option(name="--profile", multiValued=true, required=false, description="The profile IDs to associate with the new container(s). For multiple profiles, specify the flag multiple times. Defaults to the profile named, default.")
    protected List<String> profiles;
    @Option(name="--resolver", multiValued=false, required=false, description="The resolver policy for this container(s). Possible values are: localip, localhostname, publicip, publichostname, manualip. Defaults to the fabric's default resolver policy.")
    protected String resolver;
    @Option(name="--ensemble-server", multiValued=false, required=false, description="Whether the new container should be a fabric ensemble server (ZooKeeper ensemble server).")
    protected Boolean isEnsembleServer = Boolean.FALSE;
    @Option(name="--jvm-opts", multiValued=false, required=false, description="Options to pass to the container's JVM.")
    protected String jvmOpts;

    public List<String> getProfileNames() {
        List<String> names = this.profiles;
        if (names == null || names.isEmpty()) {
            names = Collections.singletonList("default");
        }
        return names;
    }

    protected void preCreateContainer(String name) throws IllegalArgumentException {
        if (!this.isEnsembleServer.booleanValue()) {
            ZooKeeperClusterService zkcs;
            ServiceReference sr = this.getBundleContext().getServiceReference(ZooKeeperClusterService.class.getName());
            ZooKeeperClusterService zooKeeperClusterService = zkcs = sr != null ? (ZooKeeperClusterService)this.getService(ZooKeeperClusterService.class, sr) : null;
            if (zkcs == null) {
                throw new IllegalStateException("Unable to find ZooKeeperClusterService service");
            }
            if (zkcs.getClusterContainers().isEmpty()) {
                if (!this.isEnsembleServer.booleanValue()) {
                    throw new IllegalStateException("The use of the --ensemble-server option is mandatory when creating an initial container");
                }
                return;
            }
            if (this.doesContainerExist(name)) {
                throw new IllegalArgumentException("A container with name " + name + " already exists.");
            }
            Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
            Profile[] profiles = ver.getProfiles();
            List<String> names = this.getProfileNames();
            for (String profile : names) {
                if (ContainerCreateSupport.hasProfile(profiles, profile, ver)) continue;
                throw new IllegalArgumentException("Profile " + profile + " with version " + ver.getName() + " does not exist.");
            }
        }
        if (!this.isEnsembleServer.booleanValue() && this.fabricService.getZookeeperUrl() == null) {
            throw new IllegalArgumentException("Either start a zookeeper ensemble or use --ensemble-server.");
        }
    }

    protected void postCreateContainers(CreateContainerMetadata[] metadatas) {
        if (!this.isEnsembleServer.booleanValue()) {
            Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
            List<String> names = this.getProfileNames();
            try {
                Profile[] profiles = this.getProfiles(ver.getName(), names);
                for (CreateContainerMetadata metadata : metadatas) {
                    if (!metadata.isSuccess()) continue;
                    Container child = metadata.getContainer();
                    this.log.trace("Setting version " + ver.getName() + " on container " + child.getId());
                    child.setVersion(ver);
                    this.log.trace("Setting profiles " + Arrays.asList(profiles) + " on container " + child.getId());
                    child.setProfiles(profiles);
                }
            }
            catch (Exception ex) {
                this.log.warn("Error during postCreateContainers. This exception will be ignored.", (Throwable)ex);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("postCreateContainers completed for " + Arrays.asList(metadatas) + " containers.");
        }
    }

    protected void displayContainers(CreateContainerMetadata[] metadatas) {
        ArrayList<CreateContainerMetadata> success = new ArrayList<CreateContainerMetadata>();
        ArrayList failures = new ArrayList();
        for (CreateContainerMetadata metadata : metadatas) {
            (metadata.isSuccess() ? success : failures).add(metadata);
        }
        if (success.size() > 0) {
            System.out.println("The following containers have been created successfully:");
            for (CreateContainerMetadata m : success) {
                System.out.println("\t" + m.toString());
            }
        }
        if (failures.size() > 0) {
            System.out.println("The following containers have failed:");
            for (CreateContainerMetadata m : failures) {
                System.out.println("\t" + m.getContainerName() + ": " + m.getFailure().getMessage());
            }
        }
    }

    private static boolean hasProfile(Profile[] profiles, String name, Version version) {
        if (profiles == null || profiles.length == 0) {
            return false;
        }
        for (Profile profile : profiles) {
            if (!profile.getId().equals(name) || !profile.getVersion().equals(version.getName())) continue;
            return true;
        }
        return false;
    }
}

