/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.boot.commands;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.internal.FabricConstants;
import org.fusesource.fabric.utils.BundleUtils;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.ZKClient;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(name="join", scope="fabric", description="Join a container to an existing fabric", detailedDescription="classpath:join.txt")
public class Join
extends OsgiCommandSupport
implements org.fusesource.fabric.boot.commands.service.Join {
    ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;
    private String version = "1.0";
    private BundleContext bundleContext;
    @Option(name="-n", aliases={"--non-managed"}, multiValued=false, description="Flag to keep the container non managed")
    private boolean nonManaged;
    @Option(name="-f", aliases={"--force"}, multiValued=false, description="Forces the use of container name")
    private boolean force;
    @Option(name="-p", aliases={"--profile"}, multiValued=false, description="Chooses the profile of the container")
    private String profile = "fabric";
    @Argument(required=true, index=0, multiValued=false, description="Zookeeper URL")
    private String zookeeperUrl;
    @Argument(required=false, index=1, multiValued=false, description="Container name to use in fabric. By default a karaf name will be used")
    private String containerName;

    protected Object doExecute() throws Exception {
        String oldName = System.getProperty("karaf.name");
        if (this.containerName == null) {
            this.containerName = oldName;
        }
        if (!this.containerName.equals(oldName)) {
            if (this.force || this.permissionToRenameContainer()) {
                if (!this.registerContainer(this.containerName, this.profile, this.force)) {
                    System.err.print("A container with the name: " + this.containerName + " is already member of the cluster. You can specify a different name as an argument.");
                    return null;
                }
                System.setProperty("karaf.name", this.containerName);
                System.setProperty("zookeeper.url", this.zookeeperUrl);
                File file = new File(System.getProperty("karaf.base") + "/etc/system.properties");
                org.apache.felix.utils.properties.Properties props = new org.apache.felix.utils.properties.Properties(file);
                props.put("karaf.name", this.containerName);
                props.put("zookeeper.url", this.zookeeperUrl);
                props.save();
                if (!this.nonManaged) {
                    this.installBundles();
                }
                Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper");
                Properties properties = new Properties();
                properties.put("zookeeper.url", this.zookeeperUrl);
                config.setBundleLocation(null);
                config.update((Dictionary)properties);
                System.setProperty("karaf.restart", "true");
                System.setProperty("karaf.restart.clean", "false");
                this.bundleContext.getBundle(0L).stop();
                return null;
            }
            return null;
        }
        if (!this.registerContainer(this.containerName, this.profile, this.force)) {
            System.err.println("A container with the name: " + this.containerName + " is already member of the cluster. You can specify a different name as an argument.");
            return null;
        }
        Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper");
        Properties properties = new Properties();
        properties.put("zookeeper.url", this.zookeeperUrl);
        config.setBundleLocation(null);
        config.update((Dictionary)properties);
        this.installBundles();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerContainer(String name, String profile, boolean force) throws InterruptedException, KeeperException {
        boolean exists = false;
        ZKClient zkClient = null;
        try {
            zkClient = new ZKClient(this.zookeeperUrl, Timespan.ONE_MINUTE, null);
            zkClient.start();
            zkClient.waitForStart();
            boolean bl = exists = zkClient.exists(ZkPath.CONTAINER.getPath(new String[]{name})) != null;
            if (!exists || force) {
                ZkPath.createContainerPaths((org.linkedin.zookeeper.client.IZKClient)zkClient, (String)this.containerName, (String)this.version, (String)profile);
            }
        }
        finally {
            if (zkClient != null) {
                zkClient.destroy();
            }
        }
        return !exists || force;
    }

    private boolean permissionToRenameContainer() throws IOException {
        String str;
        do {
            StringBuffer sb = new StringBuffer();
            System.err.println("You are about to change the container name. This action will restart the container.");
            System.err.println("The local shell will automatically restart, but ssh connections will be terminated.");
            System.err.println("The container will automatically join: " + this.zookeeperUrl + " the cluster after it restarts.");
            System.err.print("Do you wish to proceed (yes/no):");
            System.err.flush();
            while (true) {
                int c;
                if ((c = this.session.getKeyboard().read()) < 0) {
                    return false;
                }
                System.err.print((char)c);
                if (c == 13 || c == 10) break;
                sb.append((char)c);
            }
            str = sb.toString();
            if (!"yes".equals(str)) continue;
            return true;
        } while (!"no".equals(str));
        return false;
    }

    public void installBundles() throws BundleException {
        Bundle bundleFabricJaas = BundleUtils.findOrInstallBundle(this.bundleContext, "org.fusesource.fabric.fabric-jaas", "mvn:org.fusesource.fabric/fabric-jaas/" + FabricConstants.FABRIC_VERSION);
        Bundle bundleFabricCommands = BundleUtils.findOrInstallBundle(this.bundleContext, "org.fusesource.fabric.fabric-commands", "mvn:org.fusesource.fabric/fabric-commands/" + FabricConstants.FABRIC_VERSION);
        bundleFabricJaas.start();
        bundleFabricCommands.start();
        if (!this.nonManaged) {
            Bundle bundleFabricConfigAdmin = BundleUtils.findOrInstallBundle(this.bundleContext, "org.fusesource.fabric.fabric-configadmin", "mvn:org.fusesource.fabric/fabric-configadmin/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricAgent = BundleUtils.findOrInstallBundle(this.bundleContext, "org.fusesource.fabric.fabric-agent", "mvn:org.fusesource.fabric/fabric-agent/" + FabricConstants.FABRIC_VERSION);
            bundleFabricConfigAdmin.start();
            bundleFabricAgent.start();
        }
    }

    @Override
    public Object run() throws Exception {
        return this.doExecute();
    }

    @Override
    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getZookeeperUrl() {
        return this.zookeeperUrl;
    }

    @Override
    public void setZookeeperUrl(String zookeeperUrl) {
        this.zookeeperUrl = zookeeperUrl;
    }

    @Override
    public boolean isNonManaged() {
        return this.nonManaged;
    }

    @Override
    public void setNonManaged(boolean nonManaged) {
        this.nonManaged = nonManaged;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

