/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.boot.commands;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.fusesource.fabric.internal.FabricConstants;
import org.fusesource.fabric.utils.BundleUtils;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

@Command(name="join", scope="fabric", description="Join a container to an existing fabric", detailedDescription="classpath:join.txt")
public class Join
extends OsgiCommandSupport
implements org.fusesource.fabric.boot.commands.service.Join {
    ConfigurationAdmin configurationAdmin;
    private org.fusesource.fabric.zookeeper.IZKClient zooKeeper;
    private String version = "1.0";
    private BundleContext bundleContext;
    @Argument(required=true, multiValued=false, description="Zookeeper URL")
    private String zookeeperUrl;

    protected Object doExecute() throws Exception {
        Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper");
        Properties properties = new Properties();
        properties.put("zookeeper.url", this.zookeeperUrl);
        config.setBundleLocation(null);
        config.update((Dictionary)properties);
        ServiceTracker tracker = new ServiceTracker(this.bundleContext, org.fusesource.fabric.zookeeper.IZKClient.class.getName(), null);
        tracker.open();
        this.zooKeeper = (org.fusesource.fabric.zookeeper.IZKClient)tracker.waitForService(5000L);
        if (this.zooKeeper == null) {
            throw new IllegalStateException("Timeout waiting for ZooKeeper client to be registered");
        }
        tracker.close();
        this.zooKeeper.waitForConnected();
        String karafName = System.getProperty("karaf.name");
        ZkPath.createContainerPaths((IZKClient)this.zooKeeper, (String)karafName, (String)this.version);
        Bundle bundleFabricJaas = BundleUtils.findOrInstallBundle(this.bundleContext, "org.fusesource.fabric.fabric-jaas", "mvn:org.fusesource.fabric/fabric-jaas/" + FabricConstants.FABRIC_VERSION);
        Bundle bundleFabricCommands = BundleUtils.findOrInstallBundle(this.bundleContext, "org.fusesource.fabric.fabric-commands", "mvn:org.fusesource.fabric/fabric-commands/" + FabricConstants.FABRIC_VERSION);
        bundleFabricJaas.start();
        bundleFabricCommands.start();
        return null;
    }

    @Override
    public Object run() throws Exception {
        return this.doExecute();
    }

    @Override
    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public void setZooKeeper(org.fusesource.fabric.zookeeper.IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getZookeeperUrl() {
        return this.zookeeperUrl;
    }

    @Override
    public void setZookeeperUrl(String zookeeperUrl) {
        this.zookeeperUrl = zookeeperUrl;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

