/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent.sort;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;

public class RequirementSort {
    public Collection<Resource> sort(Collection<Resource> resources) {
        LinkedHashSet<Resource> sorted = new LinkedHashSet<Resource>();
        LinkedHashSet<Resource> visited = new LinkedHashSet<Resource>();
        for (Resource r : resources) {
            this.visit(r, resources, visited, sorted);
        }
        return sorted;
    }

    public TreeMap<Integer, Collection<Resource>> classify(Collection<Resource> resources) {
        TreeMap<Integer, Collection<Resource>> result = new TreeMap<Integer, Collection<Resource>>();
        Collection<Resource> sorted = this.sort(resources);
        for (Resource r : sorted) {
            int level = this.findLevel(result, r);
            if (!result.containsKey(level)) {
                LinkedList<Resource> list = new LinkedList<Resource>();
                list.add(r);
                result.put(level, list);
                continue;
            }
            result.get(level).add(r);
        }
        return result;
    }

    private int findLevel(Map<Integer, Collection<Resource>> resourceLevels, Resource resource) {
        int result = 0;
        for (Map.Entry<Integer, Collection<Resource>> entry : resourceLevels.entrySet()) {
            int level = entry.getKey();
            Collection<Resource> resources = entry.getValue();
            Set<Resource> dependencies = this.collectDependencies(resource, resources);
            if (dependencies.isEmpty() || result > level) continue;
            result = level + 1;
        }
        return result;
    }

    private void visit(Resource resource, Collection<Resource> resources, Set<Resource> visited, Set<Resource> sorted) {
        if (visited.contains(resource)) {
            return;
        }
        visited.add(resource);
        for (Resource r : this.collectDependencies(resource, resources)) {
            this.visit(r, resources, visited, sorted);
        }
        sorted.add(resource);
    }

    private Set<Resource> collectDependencies(Resource resource, Collection<Resource> allResources) {
        Requirement[] requirements;
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        for (Requirement requirement : requirements = resource.getRequirements()) {
            boolean isSatisfied = false;
            block1: for (Resource r : result) {
                for (Capability capability : r.getCapabilities()) {
                    if (!requirement.isSatisfied(capability)) continue;
                    isSatisfied = true;
                    continue block1;
                }
            }
            block3: for (Resource r : allResources) {
                if (isSatisfied) continue;
                for (Capability capability : r.getCapabilities()) {
                    if (!requirement.isSatisfied(capability)) continue;
                    result.add(r);
                    continue block3;
                }
            }
        }
        return result;
    }
}

