/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer;

import aQute.bnd.service.Plugin;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Verifier;
import aQute.libg.reporter.Reporter;
import aQute.libg.version.Version;
import aQute.libg.version.VersionRange;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRepo
implements Plugin,
RepositoryPlugin,
Refreshable {
    public static String LOCATION = "location";
    public static String READONLY = "readonly";
    public static String NAME = "name";
    File[] EMPTY_FILES = new File[0];
    protected File root;
    boolean canWrite = true;
    Pattern REPO_FILE = Pattern.compile("([-a-zA-z0-9_\\.]+)-([0-9\\.]+|latest)\\.(jar|lib)");
    Reporter reporter;
    boolean dirty;
    String name;

    public FileRepo() {
    }

    public FileRepo(String name, File location, boolean canWrite) {
        this.name = name;
        this.root = location;
        this.canWrite = canWrite;
    }

    protected void init() throws Exception {
    }

    @Override
    public void setProperties(Map<String, String> map) {
        String location = map.get(LOCATION);
        if (location == null) {
            throw new IllegalArgumentException("Location muse be set on a FileRepo plugin");
        }
        this.root = new File(location);
        if (!this.root.isDirectory()) {
            throw new IllegalArgumentException("Repository is not a valid directory " + this.root);
        }
        String readonly = map.get(READONLY);
        if (readonly != null && Boolean.valueOf(readonly).booleanValue()) {
            this.canWrite = false;
        }
        this.name = map.get(NAME);
    }

    @Override
    public File[] get(String bsn, String versionRange) throws Exception {
        this.init();
        if (versionRange != null && versionRange.equals("project")) {
            return null;
        }
        File f = new File(this.root, bsn);
        if (!f.isDirectory()) {
            return null;
        }
        VersionRange range = versionRange == null || versionRange.equals("latest") ? new VersionRange("0") : new VersionRange(versionRange);
        File[] instances = f.listFiles();
        TreeMap<Version, File> versions = new TreeMap<Version, File>();
        for (int i = 0; i < instances.length; ++i) {
            String versionString;
            Version version;
            Matcher m = this.REPO_FILE.matcher(instances[i].getName());
            if (!m.matches() || !m.group(1).equals(bsn) || !range.includes(version = (versionString = m.group(2)).equals("latest") ? new Version(Integer.MAX_VALUE) : new Version(versionString)) && !versionString.equals(versionRange)) continue;
            versions.put(version, instances[i]);
        }
        File[] files = versions.values().toArray(this.EMPTY_FILES);
        if ("latest".equals(versionRange) && files.length > 0) {
            return new File[]{files[files.length - 1]};
        }
        return files;
    }

    @Override
    public boolean canWrite() {
        return this.canWrite;
    }

    @Override
    public File put(Jar jar) throws Exception {
        this.init();
        this.dirty = true;
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            throw new IllegalArgumentException("No manifest in JAR: " + jar);
        }
        String bsn = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        if (bsn == null) {
            throw new IllegalArgumentException("No Bundle SymbolicName set");
        }
        Map<String, Map<String, String>> b = Processor.parseHeader(bsn, null);
        if (b.size() != 1) {
            throw new IllegalArgumentException("Multiple bsn's specified " + b);
        }
        for (String key : b.keySet()) {
            bsn = key;
            if (Verifier.SYMBOLICNAME.matcher(bsn).matches()) continue;
            throw new IllegalArgumentException("Bundle SymbolicName has wrong format: " + bsn);
        }
        String versionString = manifest.getMainAttributes().getValue("Bundle-Version");
        Version version = versionString == null ? new Version() : new Version(versionString);
        File dir = new File(this.root, bsn);
        dir.mkdirs();
        String fName = bsn + "-" + version.getMajor() + "." + version.getMinor() + "." + version.getMicro() + ".jar";
        File file = new File(dir, fName);
        this.reporter.trace("Updating " + file.getAbsolutePath(), new Object[0]);
        if (!file.exists() || file.lastModified() < jar.lastModified()) {
            jar.write(file);
            this.reporter.progress("Updated " + file.getAbsolutePath(), new Object[0]);
        } else {
            this.reporter.progress("Did not update " + jar + " because repo has a newer version", new Object[0]);
            this.reporter.trace("NOT Updating " + fName + " (repo is newer)", new Object[0]);
        }
        file = new File(dir, bsn + "-latest.jar");
        if (file.exists() && file.lastModified() < jar.lastModified()) {
            jar.write(file);
        }
        return file;
    }

    public void setLocation(String string) {
        this.root = new File(string);
        if (!this.root.isDirectory()) {
            throw new IllegalArgumentException("Invalid repository directory");
        }
    }

    @Override
    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public List<String> list(String regex) throws Exception {
        this.init();
        Instruction pattern = null;
        if (regex != null) {
            pattern = Instruction.getPattern(regex);
        }
        String[] list = this.root.list();
        ArrayList<String> result = new ArrayList<String>();
        if (this.root != null) {
            for (String f : list) {
                if (pattern != null && !pattern.matches(f)) continue;
                result.add(f);
            }
        } else if (this.reporter != null) {
            this.reporter.error("FileRepo root directory (%s) does not exist", this.root);
        }
        return result;
    }

    @Override
    public List<Version> versions(String bsn) throws Exception {
        this.init();
        File dir = new File(this.root, bsn);
        if (dir.isDirectory()) {
            String[] versions = dir.list();
            ArrayList<Version> list = new ArrayList<Version>();
            for (String v : versions) {
                Matcher m = this.REPO_FILE.matcher(v);
                if (!m.matches()) continue;
                String version = m.group(2);
                if (version.equals("latest")) {
                    version = "99";
                }
                list.add(new Version(version));
            }
            return list;
        }
        return null;
    }

    public String toString() {
        return String.format("%-40s r/w=%s", this.root.getAbsolutePath(), this.canWrite());
    }

    @Override
    public File getRoot() {
        return this.root;
    }

    @Override
    public boolean refresh() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return this.toString();
        }
        return this.name;
    }

    @Override
    public File get(String bsn, String range, RepositoryPlugin.Strategy strategy) throws Exception {
        File[] files = this.get(bsn, range);
        if (files.length >= 0) {
            switch (strategy) {
                case LOWEST: {
                    return files[0];
                }
                case HIGHEST: {
                    return files[files.length - 1];
                }
            }
        }
        return null;
    }
}

