/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.util;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.fusesource.common.util.Strings;
import org.fusesource.fabric.fab.osgi.util.Service;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class Services {
    public static Set<Service> parseHeader(String header) {
        HashSet<Service> services = new HashSet<Service>();
        if (Strings.notEmpty(header)) {
            Scanner scanner = new Scanner(header).useDelimiter(",");
            while (scanner.hasNext()) {
                services.add(Service.parse(scanner.next()));
            }
        }
        return services;
    }

    public static boolean isAvailable(BundleContext context, String className) throws InvalidSyntaxException {
        return Services.isAvailable(context, new Service(className));
    }

    public static boolean isAvailable(BundleContext context, String className, Map<String, String> properties) throws InvalidSyntaxException {
        return Services.isAvailable(context, new Service(className, properties));
    }

    public static boolean isAvailable(BundleContext context, Service service) throws InvalidSyntaxException {
        return service.isAvailable(context);
    }

    public static Map<String, String> createProperties(String ... elements) {
        if (elements.length % 2 != 0) {
            throw new IllegalArgumentException("Expected an even number of elements");
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (int i = 0; i < elements.length; i += 2) {
            properties.put(elements[i], elements[i + 1]);
        }
        return properties;
    }

    public static boolean isAvailable(BundleContext context, Set<Service> services) throws InvalidSyntaxException {
        for (Service service : services) {
            if (service.isAvailable(context)) continue;
            return false;
        }
        return true;
    }
}

