/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.bundlerepository.impl.RepositoryAdminImpl;
import org.fusesource.fabric.agent.DeploymentAgent;
import org.fusesource.fabric.agent.ObrResolver;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String AGENT_PID = "org.fusesource.fabric.agent";
    private static final String OBR_RESOLVE_OPTIONAL_IMPORTS = "obr.resolve.optional.imports";
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private DeploymentAgent agent;
    private ServiceTracker packageAdmin;
    private ServiceTracker startLevel;
    private ServiceTracker zkClient;
    private ServiceTracker fabricService;
    private ServiceRegistration registration;

    public void start(BundleContext context) throws Exception {
        this.agent = new DeploymentAgent();
        this.agent.setBundleContext(context);
        ObrResolver obr = new ObrResolver(new RepositoryAdminImpl(context, new org.apache.felix.utils.log.Logger(context)));
        Dictionary config = this.getConfig(context);
        if (config != null) {
            obr.setResolveOptionalImports(this.getResolveOptionalImports(config));
        }
        this.agent.setObrResolver(obr);
        this.agent.setPackageAdmin(this.getPackageAdmin(context));
        this.agent.setStartLevel(this.getStartLevel(context));
        this.agent.setZkClient(this.getZkClient(context));
        this.agent.start();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", AGENT_PID);
        this.registration = context.registerService(ManagedService.class.getName(), (Object)this.agent, props);
    }

    private boolean getResolveOptionalImports(Dictionary config) {
        try {
            return Boolean.parseBoolean((String)config.get(OBR_RESOLVE_OPTIONAL_IMPORTS));
        }
        catch (Exception e) {
            LOGGER.warn("Error reading obr.resolve.optional.imports", (Throwable)e);
            return false;
        }
    }

    private Dictionary getConfig(BundleContext bundleContext) {
        try {
            ConfigurationAdmin configAdmin;
            ServiceReference configAdminServiceReference = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
            if (configAdminServiceReference != null && (configAdmin = (ConfigurationAdmin)bundleContext.getService(configAdminServiceReference)) != null) {
                Configuration[] configuration = configAdmin.listConfigurations("(service.pid=org.fusesource.fabric.agent)");
                return configuration != null && configuration.length > 0 ? configuration[0].getProperties() : null;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to retrieve agent configuration", (Throwable)e);
        }
        return null;
    }

    private ServiceTracker getZkClient(BundleContext context) {
        this.zkClient = new ServiceTracker(context, IZKClient.class.getName(), null);
        this.zkClient.open();
        return this.zkClient;
    }

    private StartLevel getStartLevel(BundleContext context) {
        this.startLevel = new ServiceTracker(context, StartLevel.class.getName(), null);
        this.startLevel.open();
        return (StartLevel)this.startLevel.getService();
    }

    private PackageAdmin getPackageAdmin(BundleContext context) {
        this.packageAdmin = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.packageAdmin.open();
        return (PackageAdmin)this.packageAdmin.getService();
    }

    public void stop(BundleContext context) throws Exception {
        this.registration.unregister();
        context.removeFrameworkListener((FrameworkListener)this.agent);
        this.agent.stop();
        this.packageAdmin.close();
        this.startLevel.close();
        this.zkClient.close();
    }
}

