/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Instruction;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class InstructionFilter
implements FileFilter {
    private Instruction instruction;
    private boolean recursive;
    private Pattern doNotCopy;

    public InstructionFilter(Instruction instruction, boolean recursive, Pattern doNotCopy) {
        this.instruction = instruction;
        this.recursive = recursive;
        this.doNotCopy = doNotCopy;
    }

    public InstructionFilter(Instruction instruction, boolean recursive) {
        this(instruction, recursive, Pattern.compile("CVS|\\.svn|\\.git"));
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean accept(File pathname) {
        if (this.doNotCopy != null && this.doNotCopy.matcher(pathname.getName()).matches()) {
            return false;
        }
        if (pathname.isDirectory() && this.isRecursive()) {
            return true;
        }
        if (this.instruction == null) {
            return true;
        }
        return !this.instruction.isNegated() == this.instruction.matches(pathname.getName());
    }
}

