/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent;

import java.util.Hashtable;
import org.apache.felix.bundlerepository.impl.RepositoryAdminImpl;
import org.apache.felix.utils.log.Logger;
import org.fusesource.fabric.agent.DeploymentAgent;
import org.fusesource.fabric.agent.ObrResolver;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String AGENT_PID = "org.fusesource.fabric.agent";
    private DeploymentAgent agent;
    private ServiceTracker packageAdmin;
    private ServiceTracker startLevel;
    private ServiceTracker zkClient;
    private ServiceTracker fabricService;
    private ServiceRegistration registration;

    public void start(BundleContext context) throws Exception {
        this.agent = new DeploymentAgent();
        this.agent.setBundleContext(context);
        this.agent.setObrResolver(new ObrResolver(new RepositoryAdminImpl(context, new Logger(context))));
        this.agent.setPackageAdmin(this.getPackageAdmin(context));
        this.agent.setStartLevel(this.getStartLevel(context));
        this.agent.setZkClient(this.getZkClient(context));
        this.agent.start();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", AGENT_PID);
        this.registration = context.registerService(ManagedService.class.getName(), (Object)this.agent, props);
    }

    private ServiceTracker getZkClient(BundleContext context) {
        this.zkClient = new ServiceTracker(context, IZKClient.class.getName(), null);
        this.zkClient.open();
        return this.zkClient;
    }

    private StartLevel getStartLevel(BundleContext context) {
        this.startLevel = new ServiceTracker(context, StartLevel.class.getName(), null);
        this.startLevel.open();
        return (StartLevel)this.startLevel.getService();
    }

    private PackageAdmin getPackageAdmin(BundleContext context) {
        this.packageAdmin = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.packageAdmin.open();
        return (PackageAdmin)this.packageAdmin.getService();
    }

    public void stop(BundleContext context) throws Exception {
        this.registration.unregister();
        context.removeFrameworkListener((FrameworkListener)this.agent);
        this.agent.stop();
        this.packageAdmin.close();
        this.startLevel.close();
        this.zkClient.close();
    }
}

