/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Strings {
    public static boolean notEmpty(String text) {
        return text != null && text.length() > 0;
    }

    public static String nullIfEmpty(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public static String emptyIfNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static List<String> splitAsList(String text, String delimiter) {
        ArrayList<String> answer = new ArrayList<String>();
        if (text != null && text.length() > 0) {
            answer.addAll(Arrays.asList(text.split(delimiter)));
        }
        return answer;
    }

    public static List<String> splitAndTrimAsList(String text, String sep) {
        ArrayList<String> answer = new ArrayList<String>();
        if (text != null && text.length() > 0) {
            for (String v : text.split(sep)) {
                String trim = v.trim();
                if (trim.length() <= 0) continue;
                answer.add(trim);
            }
        }
        return answer;
    }

    public static String join(Collection<?> collection, String separator) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(iter.next());
        }
        return buffer.toString();
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object).toString();
        }
        return object.toString();
    }

    public static String unquote(String text) {
        if (text != null && text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }
}

