/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.commands.module;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.fab.ModuleRegistry;
import org.fusesource.fabric.fab.VersionedDependencyId;
import org.fusesource.fabric.fab.osgi.commands.CommandSupport;
import org.fusesource.fabric.fab.osgi.internal.Activator;
import org.fusesource.fabric.fab.osgi.internal.OsgiModuleRegistry;
import org.osgi.framework.Bundle;

@Command(name="uninstall", scope="module", description="Uninstall a module")
public class UninstallCommand
extends CommandSupport {
    @Argument(index=0, required=true, description="Name of the module to uninstall")
    private String name;
    @Option(name="--version", description="Version to uninstall")
    private String version;

    protected Object doExecute() throws Exception {
        OsgiModuleRegistry registry = Activator.registry;
        List<ModuleRegistry.Module> modules = registry.getApplicationModules();
        Map<VersionedDependencyId, Bundle> installed = registry.getInstalled();
        for (ModuleRegistry.Module module : modules) {
            HashSet<VersionedDependencyId> s = new HashSet<VersionedDependencyId>(module.getVersionIds());
            s.retainAll(installed.keySet());
            if (s.isEmpty() || !module.getName().equals(this.name)) continue;
            for (VersionedDependencyId dependencyId : s) {
                if (this.version != null && !this.version.equals(dependencyId.getVersion())) continue;
                installed.get(dependencyId).uninstall();
            }
        }
        return null;
    }
}

