/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.commands.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.fab.ModuleRegistry;
import org.fusesource.fabric.fab.VersionedDependencyId;
import org.fusesource.fabric.fab.osgi.commands.CommandSupport;
import org.fusesource.fabric.fab.osgi.internal.Activator;
import org.fusesource.fabric.fab.osgi.internal.OsgiModuleRegistry;
import org.fusesource.fabric.fab.util.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

@Command(name="install", scope="module", description="Install a module")
public class InstallCommand
extends CommandSupport {
    @Argument(index=0, required=true, description="Name of the module to install")
    private String name;
    @Argument(index=1, required=false, description="Extensions to enable or disable", multiValued=true)
    private String[] extensions = new String[0];
    @Option(name="--version", description="Version to install")
    private String version;
    @Option(name="--force", description="Force install")
    private boolean force;
    @Option(name="--no-start", description="Do not start the module once installed")
    private boolean noStart;

    protected Object doExecute() throws Exception {
        OsgiModuleRegistry registry = Activator.registry;
        List<ModuleRegistry.Module> modules = registry.getApplicationModules();
        Map<VersionedDependencyId, Bundle> installed = registry.getInstalled();
        for (ModuleRegistry.Module module : modules) {
            boolean isInstalled;
            if (!this.name.equals(module.getName())) continue;
            HashSet<VersionedDependencyId> s = new HashSet<VersionedDependencyId>(module.getVersionIds());
            s.retainAll(installed.keySet());
            boolean bl = isInstalled = !s.isEmpty();
            if (isInstalled && !this.force) {
                throw new Exception("The module is already installed");
            }
            ModuleRegistry.VersionedModule versionedModule = null;
            if (this.version != null) {
                versionedModule = module.getVersions().get(this.version);
                if (versionedModule == null) {
                    throw new Exception("Invalid version: " + this.version);
                }
            } else {
                versionedModule = module.latest();
            }
            VersionedDependencyId id = versionedModule.getId();
            String v = this.version != null ? this.version : id.getVersion();
            List<String> extensionAdjustments = Arrays.asList(this.extensions);
            if (!extensionAdjustments.isEmpty()) {
                ArrayList<String> enabled = new ArrayList<String>(versionedModule.getDefaultExtensions());
                for (String adjustment : extensionAdjustments) {
                    String name;
                    if (adjustment.startsWith("+")) {
                        name = adjustment.substring(1);
                        enabled.add(name);
                        continue;
                    }
                    if (adjustment.startsWith("-")) {
                        name = adjustment.substring(1);
                        enabled.remove(name);
                        continue;
                    }
                    throw new IllegalArgumentException("Expected extension argument '" + adjustment + "' to be prefixed with '+' or '-'");
                }
                versionedModule.setEnabledExtensions(enabled);
                if (!enabled.isEmpty()) {
                    this.println("Enabling extensions: " + Strings.join(enabled, ", "), new Object[0]);
                }
            }
            String url = "fab:mvn:" + id.getGroupId() + "/" + id.getArtifactId() + "/" + v + "/" + id.getExtension() + (id.getClassifier() == null ? "" : "/" + id.getClassifier());
            this.println("Installing: " + url, new Object[0]);
            Bundle bundle = this.install(url);
            if (bundle == null) continue;
            this.println("Installed bundle: %d", bundle.getBundleId());
            if (this.noStart) continue;
            bundle.start();
        }
        return null;
    }

    protected Bundle install(String location) {
        try {
            return this.getBundleContext().installBundle(location, null);
        }
        catch (BundleException ex) {
            if (ex.getNestedException() != null) {
                this.println(ex.getNestedException().toString(), new Object[0]);
            } else {
                this.println(ex.toString(), new Object[0]);
            }
        }
        catch (Exception ex) {
            this.println(ex.toString(), new Object[0]);
        }
        return null;
    }
}

