/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.fusesource.fabric.agent.DeploymentAgent;
import org.fusesource.fabric.fab.DependencyTree;
import org.fusesource.fabric.fab.osgi.FabBundleInfo;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObrResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObrResolver.class);
    private RepositoryAdmin repositoryAdmin;

    public ObrResolver() {
    }

    public ObrResolver(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }

    public RepositoryAdmin getRepositoryAdmin() {
        return this.repositoryAdmin;
    }

    public void setRepositoryAdmin(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }

    public List<Resource> resolve(Set<Feature> features, Set<String> bundles, Map<String, FabBundleInfo> fabs, Map<String, File> downloads) throws Exception {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        ArrayList<Resource> ress = new ArrayList<Resource>();
        ArrayList<Resource> deploy = new ArrayList<Resource>();
        HashMap<Object, BundleInfo> infos = new HashMap<Object, BundleInfo>();
        for (Feature feature : features) {
            Resource res;
            for (BundleInfo bundleInfo : feature.getBundles()) {
                try {
                    res = this.createResource(bundleInfo.getLocation(), downloads, fabs);
                    if (res == null) {
                        throw new IllegalArgumentException("Unable to build OBR representation for bundle " + bundleInfo.getLocation());
                    }
                    ress.add(res);
                    infos.put(res, bundleInfo);
                }
                catch (MalformedURLException e) {
                    Requirement req = this.parseRequirement(bundleInfo.getLocation());
                    reqs.add(req);
                    infos.put(req, bundleInfo);
                }
            }
            for (String bundle : bundles) {
                res = this.createResource(bundle, downloads, fabs);
                if (res == null) {
                    throw new IllegalArgumentException("Unable to build OBR representation for bundle " + bundle);
                }
                ress.add(res);
                infos.put(res, new SimpleBundleInfo(bundle, false));
            }
        }
        for (FabBundleInfo fab : fabs.values()) {
            Resource res = this.repositoryAdmin.getHelper().createResource(fab.getManifest());
            if (res == null) {
                throw new IllegalArgumentException("Unable to build OBR representation for fab " + fab.getUrl());
            }
            ((ResourceImpl)res).put("uri", "fab:" + fab.getUrl(), "uri");
            ress.add(res);
            infos.put(res, new SimpleBundleInfo(fab.getUrl(), false));
            for (DependencyTree dep : fab.getBundles()) {
                if (!dep.isBundle()) continue;
                URL url = new URL(dep.getUrl());
                Resource resDep = this.createResource(dep.getUrl(), downloads, fabs);
                if (resDep == null) {
                    throw new IllegalArgumentException("Unable to build OBR representation for fab dependency " + url);
                }
                ress.add(resDep);
                infos.put(resDep, new SimpleBundleInfo(dep.getUrl(), true));
            }
        }
        Repository repository = this.repositoryAdmin.getHelper().repository(ress.toArray(new Resource[ress.size()]));
        ArrayList<Repository> repos = new ArrayList<Repository>();
        repos.add(this.repositoryAdmin.getSystemRepository());
        repos.add(repository);
        repos.addAll(Arrays.asList(this.repositoryAdmin.listRepositories()));
        Resolver resolver = this.repositoryAdmin.resolver(repos.toArray(new Repository[repos.size()]));
        for (Resource res : ress) {
            if (((BundleInfo)infos.get(res)).isDependency()) continue;
            resolver.add(res);
        }
        for (Requirement req : reqs) {
            resolver.add(req);
        }
        if (!resolver.resolve(1)) {
            StringWriter w = new StringWriter();
            PrintWriter out = new PrintWriter(w);
            Reason[] failedReqs = resolver.getUnsatisfiedRequirements();
            if (failedReqs != null && failedReqs.length > 0) {
                out.println("Unsatisfied requirement(s):");
                this.printUnderline(out, 27);
                for (Reason r : failedReqs) {
                    out.println("   " + r.getRequirement().getName() + ":" + r.getRequirement().getFilter());
                    out.println("      " + r.getResource().getPresentationName());
                }
            } else {
                out.println("Could not resolve targets.");
            }
            out.flush();
            throw new Exception("Can not resolve feature:\n" + w.toString());
        }
        Collections.addAll(deploy, resolver.getAddedResources());
        Collections.addAll(deploy, resolver.getRequiredResources());
        return deploy;
    }

    protected Resource createResource(String uri, Map<String, File> urls, Map<String, FabBundleInfo> infos) throws IOException {
        URL url = new URL(uri);
        Attributes attributes = this.getAttributes(uri, urls, infos);
        ResourceImpl resource = (ResourceImpl)this.repositoryAdmin.getHelper().createResource(attributes);
        if (resource != null) {
            if ("file".equals(url.getProtocol())) {
                try {
                    File f = new File(url.toURI());
                    resource.put("size", Long.toString(f.length()), null);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            resource.put("uri", url.toExternalForm(), null);
        }
        return resource;
    }

    protected Attributes getAttributes(String uri, Map<String, File> urls, Map<String, FabBundleInfo> infos) throws IOException {
        InputStream is = DeploymentAgent.getBundleInputStream(uri, urls, infos);
        byte[] man = this.loadEntry(is, "META-INF/MANIFEST.MF");
        if (man == null) {
            throw new IllegalArgumentException("The specified url is not a valid jar (can't read manifest): " + uri);
        }
        Manifest manifest = new Manifest(new ByteArrayInputStream(man));
        return manifest.getMainAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadEntry(InputStream is, String name) throws IOException {
        try {
            ZipInputStream jis = new ZipInputStream(is);
            ZipEntry e = jis.getNextEntry();
            while (e != null) {
                if (name.equalsIgnoreCase(e.getName())) {
                    int n;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    while ((n = jis.read(buf, 0, buf.length)) > 0) {
                        baos.write(buf, 0, n);
                    }
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
                e = jis.getNextEntry();
            }
        }
        finally {
            is.close();
        }
        return null;
    }

    protected void printUnderline(PrintWriter out, int length) {
        for (int i = 0; i < length; ++i) {
            out.print('-');
        }
        out.println("");
    }

    protected Requirement parseRequirement(String req) throws InvalidSyntaxException {
        String filter;
        String name;
        int p = req.indexOf(58);
        if (p > 0) {
            name = req.substring(0, p);
            filter = req.substring(p + 1);
        } else {
            name = req.contains("package") ? "package" : (req.contains("service") ? "service" : "bundle");
            filter = req;
        }
        if (!filter.startsWith("(")) {
            filter = "(" + filter + ")";
        }
        return this.repositoryAdmin.getHelper().requirement(name, filter);
    }

    private static class SimpleBundleInfo
    implements BundleInfo {
        private final String bundle;
        private final boolean dependency;

        public SimpleBundleInfo(String bundle, boolean dependency) {
            this.bundle = bundle;
            this.dependency = dependency;
        }

        @Override
        public String getLocation() {
            return this.bundle;
        }

        @Override
        public int getStartLevel() {
            return 0;
        }

        @Override
        public boolean isStart() {
            return true;
        }

        @Override
        public boolean isDependency() {
            return this.dependency;
        }
    }
}

