/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import aQute.lib.osgi.Constants;
import aQute.lib.osgi.Processor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container {
    final File file;
    final TYPE type;
    final String bsn;
    final String version;
    final String error;
    final Project project;
    final Map<String, String> attributes;
    private long manifestTime;
    private Manifest manifest;

    Container(Project project, String bsn, String version, TYPE type, File source, String error, Map<String, String> attributes) {
        this.bsn = bsn;
        this.version = version;
        this.type = type;
        this.file = source != null ? source : new File("/" + bsn + ":" + version + ":" + (Object)((Object)type));
        this.project = project;
        this.error = error;
        this.attributes = attributes == null || attributes.isEmpty() ? Collections.emptyMap() : attributes;
    }

    public Container(Project project, File file) {
        this(project, file.getName(), "project", TYPE.PROJECT, file, null, null);
    }

    public Container(File file) {
        this(null, file.getName(), "project", TYPE.EXTERNAL, file, null, null);
    }

    public File getFile() {
        return this.file;
    }

    public boolean contributeFiles(List<File> files, Processor reporter) throws Exception {
        switch (this.type) {
            case EXTERNAL: 
            case REPO: {
                files.add(this.file);
                return true;
            }
            case PROJECT: {
                File[] fs = this.project.build();
                reporter.getInfo(this.project);
                if (fs == null) {
                    return false;
                }
                for (File f : fs) {
                    files.add(f);
                }
                return true;
            }
            case LIBRARY: {
                List<Container> containers = this.getMembers();
                for (Container container : containers) {
                    if (container.contributeFiles(files, reporter)) continue;
                    return false;
                }
                return true;
            }
            case ERROR: {
                reporter.error(this.error, new Object[0]);
                return false;
            }
        }
        return false;
    }

    public String getBundleSymbolicName() {
        return this.bsn;
    }

    public String getVersion() {
        return this.version;
    }

    public TYPE getType() {
        return this.type;
    }

    public String getError() {
        return this.error;
    }

    public boolean equals(Object other) {
        if (other instanceof Container) {
            return this.file.equals(((Container)other).file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public Project getProject() {
        return this.project;
    }

    public String toString() {
        if (this.getError() != null) {
            return "/error/" + this.getError();
        }
        return this.getFile().getAbsolutePath();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Container> getMembers() throws Exception {
        List<Container> result = this.project.newList();
        if (this.getType() == TYPE.LIBRARY) {
            FileInputStream in = new FileInputStream(this.file);
            BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)in, Constants.DEFAULT_CHARSET));
            try {
                String line;
                while ((line = rd.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
                    List<Container> list = this.project.getBundles(0, line);
                    result.addAll(list);
                }
            }
            finally {
                ((InputStream)in).close();
            }
        } else if (this.getType() != TYPE.MAVEN) {
            result.add(this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws Exception {
        if (this.getError() != null || this.getFile() == null) {
            return null;
        }
        if (this.manifestTime < this.getFile().lastModified()) {
            FileInputStream in = new FileInputStream(this.getFile());
            try {
                JarInputStream jin = new JarInputStream(in);
                this.manifest = jin.getManifest();
                jin.close();
                this.manifestTime = this.getFile().lastModified();
            }
            finally {
                ((InputStream)in).close();
            }
        }
        return this.manifest;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        REPO,
        PROJECT,
        EXTERNAL,
        LIBRARY,
        ERROR,
        MAVEN;

    }
}

