/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.osgi.framework.InvalidSyntaxException;

public class ObrResolver {
    private RepositoryAdmin repositoryAdmin;

    public ObrResolver() {
    }

    public ObrResolver(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }

    public RepositoryAdmin getRepositoryAdmin() {
        return this.repositoryAdmin;
    }

    public void setRepositoryAdmin(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }

    public List<Resource> resolve(Set<Feature> features, Set<String> bundles) throws Exception {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        ArrayList<Resource> ress = new ArrayList<Resource>();
        ArrayList<Resource> deploy = new ArrayList<Resource>();
        HashMap<Object, BundleInfo> infos = new HashMap<Object, BundleInfo>();
        for (Feature feature : features) {
            Resource res;
            URL url;
            for (BundleInfo bundleInfo : feature.getBundles()) {
                try {
                    url = new URL(bundleInfo.getLocation());
                    res = this.repositoryAdmin.getHelper().createResource(url);
                    ress.add(res);
                    infos.put(res, bundleInfo);
                }
                catch (MalformedURLException e) {
                    Requirement req = this.parseRequirement(bundleInfo.getLocation());
                    reqs.add(req);
                    infos.put(req, bundleInfo);
                }
            }
            for (String bundle : bundles) {
                url = new URL(bundle);
                res = this.repositoryAdmin.getHelper().createResource(url);
                ress.add(res);
                infos.put(res, new SimpleBundleInfo(bundle));
            }
        }
        Repository repository = this.repositoryAdmin.getHelper().repository(ress.toArray(new Resource[ress.size()]));
        ArrayList<Repository> repos = new ArrayList<Repository>();
        repos.add(this.repositoryAdmin.getSystemRepository());
        repos.add(repository);
        repos.addAll(Arrays.asList(this.repositoryAdmin.listRepositories()));
        Resolver resolver = this.repositoryAdmin.resolver(repos.toArray(new Repository[repos.size()]));
        for (Resource res : ress) {
            if (((BundleInfo)infos.get(res)).isDependency()) continue;
            resolver.add(res);
        }
        for (Requirement req : reqs) {
            resolver.add(req);
        }
        if (!resolver.resolve(1)) {
            StringWriter w = new StringWriter();
            PrintWriter out = new PrintWriter(w);
            Reason[] failedReqs = resolver.getUnsatisfiedRequirements();
            if (failedReqs != null && failedReqs.length > 0) {
                out.println("Unsatisfied requirement(s):");
                this.printUnderline(out, 27);
                for (Reason r : failedReqs) {
                    out.println("   " + r.getRequirement().getName() + ":" + r.getRequirement().getFilter());
                    out.println("      " + r.getResource().getPresentationName());
                }
            } else {
                out.println("Could not resolve targets.");
            }
            out.flush();
            throw new Exception("Can not resolve feature:\n" + w.toString());
        }
        Collections.addAll(deploy, resolver.getAddedResources());
        Collections.addAll(deploy, resolver.getRequiredResources());
        return deploy;
    }

    protected void printUnderline(PrintWriter out, int length) {
        for (int i = 0; i < length; ++i) {
            out.print('-');
        }
        out.println("");
    }

    protected Requirement parseRequirement(String req) throws InvalidSyntaxException {
        String filter;
        String name;
        int p = req.indexOf(58);
        if (p > 0) {
            name = req.substring(0, p);
            filter = req.substring(p + 1);
        } else {
            name = req.contains("package") ? "package" : (req.contains("service") ? "service" : "bundle");
            filter = req;
        }
        if (!filter.startsWith("(")) {
            filter = "(" + filter + ")";
        }
        return this.repositoryAdmin.getHelper().requirement(name, filter);
    }

    private static class SimpleBundleInfo
    implements BundleInfo {
        private final String bundle;

        public SimpleBundleInfo(String bundle) {
            this.bundle = bundle;
        }

        @Override
        public String getLocation() {
            return this.bundle;
        }

        @Override
        public int getStartLevel() {
            return 0;
        }

        @Override
        public boolean isStart() {
            return true;
        }

        @Override
        public boolean isDependency() {
            return false;
        }
    }
}

