/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.internal.ZooKeeperAware;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafAgentRegistration
implements LifecycleListener,
ZooKeeperAware,
NotificationListener {
    private transient Logger logger = LoggerFactory.getLogger(KarafAgentRegistration.class);
    private ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;
    private BundleContext bundleContext;
    private Set<String> domains = new CopyOnWriteArraySet<String>();
    private volatile MBeanServer mbeanServer;
    private volatile boolean connected;

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void onConnected() {
        try {
            String sshUrl;
            String jmxUrl;
            String domainsNode;
            this.connected = true;
            String name = System.getProperty("karaf.name");
            String nodeAlive = ZkPath.AGENT_ALIVE.getPath(name);
            Stat stat = this.zooKeeper.exists(nodeAlive);
            if (stat != null) {
                if (stat.getEphemeralOwner() != this.zooKeeper.getSessionId()) {
                    this.zooKeeper.delete(nodeAlive);
                    this.zooKeeper.createWithParents(nodeAlive, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                }
            } else {
                this.zooKeeper.createWithParents(nodeAlive, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            }
            if ((stat = this.zooKeeper.exists(domainsNode = ZkPath.AGENT_DOMAINS.getPath(name))) != null) {
                this.zooKeeper.deleteWithChildren(domainsNode);
            }
            if ((jmxUrl = this.getJmxUrl()) != null) {
                this.zooKeeper.createOrSetWithParents(ZkPath.AGENT_JMX.getPath(name), this.getJmxUrl(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            if ((sshUrl = this.getSshUrl()) != null) {
                this.zooKeeper.createOrSetWithParents(ZkPath.AGENT_SSH.getPath(name), this.getSshUrl(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            this.zooKeeper.createOrSetWithParents(ZkPath.AGENT_IP.getPath(name), KarafAgentRegistration.getLocalHostAddress(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.zooKeeper.createOrSetWithParents(ZkPath.AGENT_ROOT.getPath(name), this.getRootName(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.registerDomains();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRootName() throws IOException {
        String base;
        String home = System.getProperty("karaf.home");
        if (home.equals(base = System.getProperty("karaf.base"))) {
            return "";
        }
        File f = new File(home, "etc/system.properties");
        FileInputStream is = new FileInputStream(f);
        try {
            Properties p = new Properties();
            p.load(is);
            String string = p.getProperty("karaf.name");
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private String getJmxUrl() throws IOException {
        Configuration config = this.configurationAdmin.getConfiguration("org.apache.karaf.management");
        if (config.getProperties() != null) {
            String jmx = (String)config.getProperties().get("serviceUrl");
            jmx = jmx.replace("service:jmx:rmi://localhost:", "service:jmx:rmi://" + KarafAgentRegistration.getLocalHostAddress() + ":");
            return jmx;
        }
        return null;
    }

    private String getSshUrl() throws IOException {
        Configuration config = this.configurationAdmin.getConfiguration("org.apache.karaf.shell");
        if (config != null) {
            String host = (String)config.getProperties().get("sshHost");
            String port = (String)config.getProperties().get("sshPort");
            return KarafAgentRegistration.getExternalAddresses(host, port);
        }
        return null;
    }

    private static String getLocalHostAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    private static String getExternalAddresses(String host, String port) throws UnknownHostException {
        InetAddress ip = InetAddress.getByName(host);
        if (ip.isAnyLocalAddress()) {
            return KarafAgentRegistration.getLocalHostAddress() + ":" + port;
        }
        if (!ip.isLoopbackAddress()) {
            return ip.getHostName() + ":" + port;
        }
        return null;
    }

    public void onDisconnected() {
        this.connected = false;
        try {
            this.unregisterDomains();
        }
        catch (ServiceException e) {
            this.logger.trace("Mbean server is no longer available", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.warn("An error occured during disconnecting to zookeeper", (Throwable)e);
        }
    }

    public void registerMBeanServer(ServiceReference ref) {
        try {
            String name = System.getProperty("karaf.name");
            this.mbeanServer = (MBeanServer)this.bundleContext.getService(ref);
            this.mbeanServer.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, (Object)name);
            this.registerDomains();
        }
        catch (Exception e) {
            this.logger.warn("An error occured during mbean server registration");
        }
    }

    public void unregisterMBeanServer(ServiceReference ref) {
        try {
            this.mbeanServer.removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this);
            this.unregisterDomains();
        }
        catch (Exception e) {
            this.logger.warn("An error occured during mbean server unregistration");
        }
        this.mbeanServer = null;
        this.bundleContext.ungetService(ref);
    }

    protected void registerDomains() throws InterruptedException, KeeperException {
        if (this.connected && this.mbeanServer != null) {
            String name = System.getProperty("karaf.name");
            this.domains.addAll(Arrays.asList(this.mbeanServer.getDomains()));
            for (String domain : this.mbeanServer.getDomains()) {
                this.zooKeeper.createOrSetWithParents(ZkPath.AGENT_DOMAIN.getPath(name, domain), null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
    }

    protected void unregisterDomains() throws InterruptedException, KeeperException {
        if (this.connected) {
            String name = System.getProperty("karaf.name");
            String domainsPath = ZkPath.AGENT_DOMAINS.getPath(name);
            if (this.zooKeeper.exists(domainsPath) != null) {
                for (String child : this.zooKeeper.getChildren(domainsPath)) {
                    this.zooKeeper.delete(domainsPath + "/" + child);
                }
            }
        }
    }

    @Override
    public void handleNotification(Notification notif, Object o) {
        if (this.connected && this.mbeanServer != null && notif instanceof MBeanServerNotification) {
            MBeanServerNotification notification = (MBeanServerNotification)notif;
            String domain = notification.getMBeanName().getDomain();
            String path = ZkPath.AGENT_DOMAIN.getPath((String)o, domain);
            try {
                if ("JMX.mbean.registered".equals(notification.getType())) {
                    if (this.domains.add(domain) && this.zooKeeper.exists(path) == null) {
                        this.zooKeeper.create(path, "", (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                } else if ("JMX.mbean.unregistered".equals(notification.getType())) {
                    this.domains.clear();
                    this.domains.addAll(Arrays.asList(this.mbeanServer.getDomains()));
                    if (!this.domains.contains(domain)) {
                        this.zooKeeper.delete(path);
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("Exception while jmx domain synchronization", (Throwable)e);
            }
        }
    }
}

