/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.activemq.facade;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.activemq.broker.jmx.ConnectionViewMBean;
import org.apache.activemq.broker.jmx.ConnectorViewMBean;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.apache.activemq.broker.jmx.JobSchedulerViewMBean;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.NetworkBridgeViewMBean;
import org.apache.activemq.broker.jmx.NetworkConnectorViewMBean;
import org.apache.activemq.broker.jmx.ProducerViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.jmx.SubscriptionViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.fusesource.fabric.activemq.facade.BrokerFacade;
import org.fusesource.fabric.activemq.facade.BrokerViewFacade;
import org.fusesource.fabric.activemq.facade.ConnectionViewFacade;
import org.fusesource.fabric.activemq.facade.ConnectorViewFacade;
import org.fusesource.fabric.activemq.facade.DurableSubscriptionViewFacade;
import org.fusesource.fabric.activemq.facade.JobFacade;
import org.fusesource.fabric.activemq.facade.JobSchedulerViewFacade;
import org.fusesource.fabric.activemq.facade.NetworkBridgeViewFacade;
import org.fusesource.fabric.activemq.facade.NetworkConnectorViewFacade;
import org.fusesource.fabric.activemq.facade.ProducerViewFacade;
import org.fusesource.fabric.activemq.facade.QueueViewFacade;
import org.fusesource.fabric.activemq.facade.SubscriptionViewFacade;
import org.fusesource.fabric.activemq.facade.TopicViewFacade;
import org.springframework.util.StringUtils;

public abstract class BrokerFacadeSupport
implements BrokerFacade {
    public abstract ManagementContext getManagementContext();

    public abstract Set queryNames(ObjectName var1, QueryExp var2) throws Exception;

    public abstract Object newProxyInstance(ObjectName var1, Class var2, boolean var3) throws Exception;

    public static <T> T proxy(Class<T> ic, final Object target, final String id) throws Exception {
        return ic.cast(Proxy.newProxyInstance(ic.getClassLoader(), new Class[]{ic}, new InvocationHandler(){

            @Override
            public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                if (method.getName() == "getId" && method.getParameterTypes().length == 0) {
                    return id;
                }
                return method.invoke(target, objects);
            }
        }));
    }

    @Override
    public Collection<QueueViewFacade> getQueues() throws Exception {
        BrokerViewFacade broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getQueues();
        return this.getManagedObjects(queues, QueueViewMBean.class, QueueViewFacade.class);
    }

    @Override
    public Collection<TopicViewFacade> getTopics() throws Exception {
        BrokerViewFacade broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getTopics();
        return this.getManagedObjects(queues, TopicViewMBean.class, TopicViewFacade.class);
    }

    @Override
    public Collection<DurableSubscriptionViewFacade> getDurableTopicSubscribers() throws Exception {
        BrokerViewFacade broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getDurableTopicSubscribers();
        return this.getManagedObjects(queues, DurableSubscriptionViewMBean.class, DurableSubscriptionViewFacade.class);
    }

    @Override
    public Collection<DurableSubscriptionViewFacade> getInactiveDurableTopicSubscribers() throws Exception {
        BrokerViewFacade broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getInactiveDurableTopicSubscribers();
        return this.getManagedObjects(queues, DurableSubscriptionViewMBean.class, DurableSubscriptionViewFacade.class);
    }

    @Override
    public QueueViewFacade getQueue(String name) throws Exception {
        return (QueueViewFacade)this.getDestinationByName(this.getQueues(), name);
    }

    @Override
    public TopicViewFacade getTopic(String name) throws Exception {
        return (TopicViewFacade)this.getDestinationByName(this.getTopics(), name);
    }

    protected DestinationViewMBean getDestinationByName(Collection<? extends DestinationViewMBean> collection, String name) {
        for (DestinationViewMBean destinationViewMBean : collection) {
            if (!name.equals(destinationViewMBean.getName())) continue;
            return destinationViewMBean;
        }
        return null;
    }

    protected <T> Collection<T> getManagedObjects(ObjectName[] names, Class<?> type, Class<T> type2) throws Exception {
        ArrayList<T> answer = new ArrayList<T>();
        for (int i = 0; i < names.length; ++i) {
            ObjectName name = names[i];
            Object value = this.newProxyInstance(name, type, true);
            if (value == null) continue;
            answer.add(BrokerFacadeSupport.proxy(type2, value, name.getCanonicalName()));
        }
        return answer;
    }

    @Override
    public Collection<ConnectionViewFacade> getConnections() throws Exception {
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Connection,*");
        Set queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), ConnectionViewMBean.class, ConnectionViewFacade.class);
    }

    @Override
    public Collection<String> getConnections(String connectorName) throws Exception {
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Connection,ConnectorName=" + connectorName + ",*");
        Set queryResult = this.queryNames(query, null);
        ArrayList<String> result = new ArrayList<String>(queryResult.size());
        for (ObjectName on : queryResult) {
            String name = StringUtils.replace((String)on.getKeyProperty("Connection"), (String)"_", (String)":");
            result.add(name);
        }
        return result;
    }

    @Override
    public ConnectionViewFacade getConnection(String connectionName) throws Exception {
        connectionName = StringUtils.replace((String)connectionName, (String)":", (String)"_");
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Connection,*,Connection=" + connectionName);
        Set queryResult = this.queryNames(query, null);
        if (queryResult.size() == 0) {
            return null;
        }
        ObjectName objectName = (ObjectName)queryResult.iterator().next();
        Object rc = this.newProxyInstance(objectName, ConnectionViewMBean.class, true);
        return BrokerFacadeSupport.proxy(ConnectionViewFacade.class, rc, objectName.getCanonicalName());
    }

    @Override
    public Collection<String> getConnectors() throws Exception {
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Connector,*");
        Set queryResult = this.queryNames(query, null);
        ArrayList<String> result = new ArrayList<String>(queryResult.size());
        for (ObjectName on : queryResult) {
            result.add(on.getKeyProperty("ConnectorName"));
        }
        return result;
    }

    @Override
    public ConnectorViewFacade getConnector(String name) throws Exception {
        String brokerName = this.getBrokerName();
        ObjectName objectName = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Connector,ConnectorName=" + name);
        Object rc = this.newProxyInstance(objectName, ConnectorViewMBean.class, true);
        return BrokerFacadeSupport.proxy(ConnectorViewFacade.class, rc, objectName.getCanonicalName());
    }

    @Override
    public Collection<NetworkConnectorViewFacade> getNetworkConnectors() throws Exception {
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=NetworkConnector,*");
        Set queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), NetworkConnectorViewMBean.class, NetworkConnectorViewFacade.class);
    }

    @Override
    public Collection<NetworkBridgeViewFacade> getNetworkBridges() throws Exception {
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=NetworkBridge,*");
        Set queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), NetworkBridgeViewMBean.class, NetworkBridgeViewFacade.class);
    }

    @Override
    public Collection<SubscriptionViewFacade> getQueueConsumers(String queueName) throws Exception {
        String brokerName = this.getBrokerName();
        queueName = StringUtils.replace((String)queueName, (String)"\"", (String)"_");
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Subscription,destinationType=Queue,destinationName=" + queueName + ",*");
        Set queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), SubscriptionViewMBean.class, SubscriptionViewFacade.class);
    }

    @Override
    public Collection<SubscriptionViewFacade> getTopicConsumers(String topicName) throws Exception {
        String brokerName = this.getBrokerName();
        topicName = StringUtils.replace((String)topicName, (String)"\"", (String)"_");
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Subscription,persistentMode=Non-Durable,destinationType=Topic,destinationName=" + topicName + ",*");
        Set queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), SubscriptionViewMBean.class, SubscriptionViewFacade.class);
    }

    @Override
    public Collection<DurableSubscriptionViewFacade> getTopicDurableConsumers(String topicName) throws Exception {
        String brokerName = this.getBrokerName();
        topicName = StringUtils.replace((String)topicName, (String)"\"", (String)"_");
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Subscription,persistentMode=Durable,destinationType=Topic,destinationName=" + topicName + ",*");
        Set queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), DurableSubscriptionViewMBean.class, DurableSubscriptionViewFacade.class);
    }

    @Override
    public Collection<ProducerViewFacade> getQueueProducers(String queueName) throws Exception {
        String brokerName = this.getBrokerName();
        queueName = StringUtils.replace((String)queueName, (String)"\"", (String)"_");
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Producer,destinationType=Queue,destinationName=" + queueName + ",*");
        Set queryResult = this.queryNames(query, null);
        Collection<ProducerViewFacade> producers = this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), ProducerViewMBean.class, ProducerViewFacade.class);
        query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Producer,destinationType=Dynamic,*");
        queryResult = this.queryNames(query, null);
        Collection<ProducerViewFacade> dynamics = this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), ProducerViewMBean.class, ProducerViewFacade.class);
        for (ProducerViewFacade dynamicProducer : dynamics) {
            if (!queueName.equals(dynamicProducer.getDestinationName())) continue;
            producers.add(dynamicProducer);
        }
        return producers;
    }

    @Override
    public Collection<ProducerViewFacade> getTopicProducers(String topicName) throws Exception {
        String brokerName = this.getBrokerName();
        topicName = StringUtils.replace((String)topicName, (String)"\"", (String)"_");
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Producer,destinationType=Topic,destinationName=" + topicName + ",*");
        Set queryResult = this.queryNames(query, null);
        Collection<ProducerViewFacade> producers = this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), ProducerViewMBean.class, ProducerViewFacade.class);
        query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Producer,destinationType=Dynamic,*");
        queryResult = this.queryNames(query, null);
        Collection<ProducerViewFacade> dynamics = this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), ProducerViewMBean.class, ProducerViewFacade.class);
        for (ProducerViewFacade dynamicProducer : dynamics) {
            if (!topicName.equals(dynamicProducer.getDestinationName())) continue;
            producers.add(dynamicProducer);
        }
        return producers;
    }

    @Override
    public Collection<SubscriptionViewFacade> getConsumersOnConnection(String connectionName) throws Exception {
        connectionName = StringUtils.replace((String)connectionName, (String)":", (String)"_");
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Subscription,clientId=" + connectionName + ",*");
        Set queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), SubscriptionViewFacade.class, SubscriptionViewFacade.class);
    }

    @Override
    public JobSchedulerViewFacade getJobScheduler() throws Exception {
        ObjectName name = this.getBrokerAdmin().getJMSJobScheduler();
        Object rc = this.newProxyInstance(name, JobSchedulerViewMBean.class, true);
        return BrokerFacadeSupport.proxy(JobSchedulerViewFacade.class, rc, name.getCanonicalName());
    }

    @Override
    public Collection<JobFacade> getScheduledJobs() throws Exception {
        JobSchedulerViewFacade jobScheduler = this.getJobScheduler();
        ArrayList<JobFacade> result = new ArrayList<JobFacade>();
        TabularData table = jobScheduler.getAllJobs();
        for (Object object : table.values()) {
            CompositeData cd = (CompositeData)object;
            JobFacade jf = new JobFacade(cd);
            result.add(jf);
        }
        return result;
    }

    @Override
    public boolean isJobSchedulerStarted() {
        try {
            JobSchedulerViewFacade jobScheduler = this.getJobScheduler();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

