/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.tooling.util;

import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.UnmarshalDefinition;

public class CamelModelUtils {
    public static boolean canAcceptInput(String className) {
        Object def;
        Class<?> aClass;
        try {
            aClass = Class.forName(className);
            def = aClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate " + className + ". " + e, e);
        }
        if (def instanceof ProcessorDefinition) {
            return CamelModelUtils.canAcceptOutput(aClass, (ProcessorDefinition)def);
        }
        throw new IllegalArgumentException("The class is not a ProcessorDefinition! " + aClass);
    }

    public static boolean canAcceptOutput(Class<?> aClass, ProcessorDefinition def) {
        if (aClass == null) {
            return false;
        }
        if (BeanDefinition.class.isAssignableFrom(aClass)) {
            return false;
        }
        if (MarshalDefinition.class.isAssignableFrom(aClass) || UnmarshalDefinition.class.isAssignableFrom(aClass) || TransactedDefinition.class.isAssignableFrom(aClass)) {
            return false;
        }
        if (ProcessorDefinition.class.isAssignableFrom(aClass) && def != null) {
            boolean answer = def.isOutputSupported();
            return answer;
        }
        return false;
    }

    public static boolean isNextSiblingStepAddedAsNodeChild(Class<?> aClass, ProcessorDefinition def) {
        boolean acceptOutput = CamelModelUtils.canAcceptOutput(aClass, def);
        return !acceptOutput || PolicyDefinition.class.isAssignableFrom(aClass);
    }
}

