/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.Child;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.Parent;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.IOException;
import java.io.Writer;

public class Location {
    private XMLSource source;
    private Element element;
    private Document document;
    private Node node;
    private int offset = -1;
    private int line = 0;
    private int lineStartOffset = -1;
    private int column = 0;

    public Location(XMLSource source, int offset) {
        this.source = source;
        this.offset = offset;
    }

    public Location(Element e) {
        this.element = e;
    }

    public Location(Document document, Node node) {
        if (document == null) {
            throw new IllegalArgumentException("document is null");
        }
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        this.document = document;
        this.node = node;
    }

    public Location(Token token) {
        this(token.getSource(), token.getStartOffset());
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLine() {
        if (this.line == 0) {
            this.calcLocation();
        }
        return this.line;
    }

    public int getColumn() {
        if (this.line == 0) {
            this.calcLocation();
        }
        return this.column;
    }

    public int getLineStartOffset() {
        if (this.line == 0) {
            this.calcLocation();
        }
        return this.lineStartOffset;
    }

    protected void calcLocation() {
        if (this.source == null) {
            this.calcLocationFromElement();
        } else {
            this.calcLocationFromSource();
        }
    }

    protected void calcLocationFromSource() {
        if (this.source == null) {
            return;
        }
        this.line = 1;
        this.column = 1;
        this.lineStartOffset = 0;
        this.moveToOffset(this.source, this.offset);
    }

    protected void moveToOffset(XMLSource source, int offset) {
        offset = Math.min(source.length(), offset);
        for (int i = 0; i < offset; ++i) {
            char c = source.charAt(i);
            if (c == '\r' || c == '\n') {
                ++this.line;
                this.column = 1;
                if (c == '\r' && i + 1 < source.length() && source.charAt(i + 1) == '\n') {
                    ++i;
                }
                this.lineStartOffset = i + 1;
                continue;
            }
            if (c == '\t') {
                this.column += 8 - this.column % 8 + 1;
                continue;
            }
            ++this.column;
        }
    }

    protected void calcLocationFromElement() {
        block6: {
            Parent p;
            if (this.element == null && this.document == null) {
                return;
            }
            this.line = 1;
            this.column = 1;
            this.lineStartOffset = 0;
            this.offset = 0;
            final ReusableXMLSource source = new ReusableXMLSource();
            final Node terminator = this.node == null ? this.element : this.node;
            XMLWriter writer = new XMLWriter(new Writer(){

                public void close() throws IOException {
                }

                public void flush() throws IOException {
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                }
            }){

                public void write(Node n, String xml) throws IOException {
                    if (n == terminator) {
                        throw new NodeFoundException();
                    }
                    source.source = xml;
                    Location.this.moveToOffset(source, xml.length());
                    Location.this.offset += xml.length();
                }
            };
            if (this.document == null) {
                Child c;
                p = this.element;
                while (p instanceof Child && (c = (Child)((Object)p)).getParent() != null) {
                    p = c.getParent();
                }
            } else {
                p = this.document;
            }
            try {
                p.toXML(writer);
                this.nodeNotFound();
            }
            catch (IOException e) {
                if (e instanceof NodeFoundException) break block6;
                this.nodeNotFound();
            }
        }
    }

    protected void nodeNotFound() {
        this.line = 0;
        this.column = 0;
        this.offset = -1;
        this.lineStartOffset = -1;
    }

    public String toString() {
        return this.getLine() + ":" + this.getColumn();
    }

    public static class NodeFoundException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }

    public static class ReusableXMLSource
    implements XMLSource {
        public String source;

        public char charAt(int offset) {
            return this.source.charAt(offset);
        }

        public int length() {
            return this.source.length();
        }

        public String substring(int start, int end) {
            return this.source.substring(start, end);
        }
    }
}

