/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TimerListener;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed Route")
public class ManagedRoute
extends ManagedPerformanceCounter
implements TimerListener,
ManagedRouteMBean {
    public static final String VALUE_UNKNOWN = "Unknown";
    protected final Route route;
    protected final String description;
    protected final ModelCamelContext context;
    private final LoadTriplet load = new LoadTriplet();

    public ManagedRoute(ModelCamelContext context, Route route) {
        this.route = route;
        this.context = context;
        this.description = route.toString();
        boolean enabled = context.getManagementStrategy().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
    }

    public Route getRoute() {
        return this.route;
    }

    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public String getRouteId() {
        String id = this.route.getId();
        if (id == null) {
            id = VALUE_UNKNOWN;
        }
        return id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getEndpointUri() {
        Endpoint ep = this.route.getEndpoint();
        return ep != null ? ep.getEndpointUri() : VALUE_UNKNOWN;
    }

    @Override
    public String getState() {
        ServiceStatus status = this.context.getRouteStatus(this.route.getId());
        if (status == null) {
            status = ServiceStatus.Stopped;
        }
        return status.name();
    }

    @Override
    public Integer getInflightExchanges() {
        return this.context.getInflightRepository().size(this.route.getId());
    }

    @Override
    public String getCamelId() {
        return this.context.getName();
    }

    @Override
    public Boolean getTracing() {
        return this.route.getRouteContext().isTracing();
    }

    @Override
    public void setTracing(Boolean tracing) {
        this.route.getRouteContext().setTracing(tracing);
    }

    @Override
    public String getRoutePolicyList() {
        List<RoutePolicy> policyList = this.route.getRouteContext().getRoutePolicyList();
        if (policyList == null || policyList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < policyList.size(); ++i) {
            RoutePolicy policy = policyList.get(i);
            sb.append(policy.getClass().getSimpleName());
            sb.append("(").append(ObjectHelper.getIdentityHashCode(policy)).append(")");
            if (i >= policyList.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public String getLoad01() {
        return String.format("%.2f", this.load.getLoad1());
    }

    @Override
    public String getLoad05() {
        return String.format("%.2f", this.load.getLoad5());
    }

    @Override
    public String getLoad15() {
        return String.format("%.2f", this.load.getLoad15());
    }

    @Override
    public void onTimer() {
        this.load.update(this.getInflightExchanges());
    }

    @Override
    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.startRoute(this.getRouteId());
    }

    @Override
    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.stopRoute(this.getRouteId());
    }

    @Override
    public void stop(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.stopRoute(this.getRouteId(), timeout, TimeUnit.SECONDS);
    }

    @Override
    public boolean stop(Long timeout, Boolean abortAfterTimeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        return this.context.stopRoute(this.getRouteId(), timeout, TimeUnit.SECONDS, abortAfterTimeout);
    }

    @Override
    public void shutdown() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        String routeId = this.getRouteId();
        this.context.stopRoute(routeId);
        this.context.removeRoute(routeId);
    }

    @Override
    public void shutdown(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        String routeId = this.getRouteId();
        this.context.stopRoute(routeId, timeout, TimeUnit.SECONDS);
        this.context.removeRoute(routeId);
    }

    @Override
    public boolean remove() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        return this.context.removeRoute(this.getRouteId());
    }

    @Override
    public String dumpRouteAsXml() throws Exception {
        String id = this.route.getId();
        RouteDefinition def = this.context.getRouteDefinition(id);
        if (def != null) {
            return ModelHelper.dumpModelAsXml(def);
        }
        return null;
    }

    @Override
    public void updateRouteFromXml(String xml) throws Exception {
        RouteDefinition def = ModelHelper.createModelFromXml(xml, RouteDefinition.class);
        if (def == null) {
            return;
        }
        this.context.addRouteDefinition(def);
    }

    @Override
    public String dumpRouteStatsAsXml(boolean fullStats, boolean includeProcessors) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<routeStat").append(String.format(" id=\"%s\"", this.route.getId()));
        String stat = this.dumpStatsAsXml(fullStats);
        sb.append(" ").append(stat.substring(7, stat.length() - 2)).append(">\n");
        if (includeProcessors) {
            sb.append("  <processorStats>\n");
            MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
            if (server != null) {
                ObjectName query = ObjectName.getInstance("org.apache.camel:context=*/" + this.getContext().getManagementName() + ",type=processors,*");
                Set<ObjectName> names = server.queryNames(query, null);
                for (ObjectName on : names) {
                    ManagedProcessorMBean processor = MBeanServerInvocationHandler.newProxyInstance(server, on, ManagedProcessorMBean.class, true);
                    if (!this.getRouteId().equals(processor.getRouteId())) continue;
                    sb.append("    <processorStat").append(String.format(" id=\"%s\"", processor.getProcessorId()));
                    sb.append(" ").append(processor.dumpStatsAsXml(fullStats).substring(7)).append("\n");
                }
            }
            sb.append("  </processorStats>\n");
        }
        sb.append("</routeStat>");
        return sb.toString();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.route.equals(((ManagedRoute)o).route);
    }

    public int hashCode() {
        return this.route.hashCode();
    }
}

