/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperations
implements GenericFileOperations<File> {
    private static final transient Logger LOG = LoggerFactory.getLogger(FileOperations.class);
    private FileEndpoint endpoint;

    public FileOperations() {
    }

    public FileOperations(FileEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setEndpoint(GenericFileEndpoint<File> endpoint) {
        this.endpoint = (FileEndpoint)endpoint;
    }

    @Override
    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        File file = new File(name);
        return FileUtil.deleteFile(file);
    }

    @Override
    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        File file = new File(from);
        File target = new File(to);
        try {
            return FileUtil.renameFile(file, target, this.endpoint.isCopyAndDeleteOnRenameFail());
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Error renaming file from " + from + " to " + to, e);
        }
    }

    @Override
    public boolean existsFile(String name) throws GenericFileOperationFailedException {
        File file = new File(name);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        String afterRoot;
        ObjectHelper.notNull(this.endpoint, "endpoint");
        if (this.endpoint.isAutoCreate() && !this.endpoint.getFile().exists()) {
            LOG.trace("Building starting directory: {}", this.endpoint.getFile());
            this.endpoint.getFile().mkdirs();
        }
        if (ObjectHelper.isEmpty(directory)) {
            return true;
        }
        File endpointPath = this.endpoint.getFile();
        File target = new File(directory);
        File path = absolute ? target : (endpointPath.equals(target) ? endpointPath : (ObjectHelper.isNotEmpty(afterRoot = ObjectHelper.after(directory, endpointPath.getPath() + File.separator)) ? new File(this.endpoint.getFile(), afterRoot) : new File(this.endpoint.getFile(), directory)));
        FileOperations fileOperations = this;
        synchronized (fileOperations) {
            if (path.isDirectory() && path.exists()) {
                return true;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Building directory: {}", path);
            }
            return path.mkdirs();
        }
    }

    @Override
    public List<File> listFiles() throws GenericFileOperationFailedException {
        return null;
    }

    @Override
    public List<File> listFiles(String path) throws GenericFileOperationFailedException {
        return null;
    }

    @Override
    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
    }

    @Override
    public void changeToParentDirectory() throws GenericFileOperationFailedException {
    }

    @Override
    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        return null;
    }

    @Override
    public boolean retrieveFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        return true;
    }

    @Override
    public void releaseRetreivedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
    }

    @Override
    public boolean storeFile(String fileName, Exchange exchange) throws GenericFileOperationFailedException {
        ObjectHelper.notNull(this.endpoint, "endpoint");
        File file = new File(fileName);
        if (file.exists()) {
            if (this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                LOG.trace("An existing file already exists: {}. Ignore and do not override it.", file);
                return true;
            }
            if (this.endpoint.getFileExist() == GenericFileExist.Fail) {
                throw new GenericFileOperationFailedException("File already exist: " + file + ". Cannot write new file.");
            }
            if (this.endpoint.getFileExist() == GenericFileExist.Move) {
                this.doMoveExistingFile(fileName);
            }
        }
        if (exchange.getIn().getBody() == null) {
            if (this.endpoint.isAllowNullBody()) {
                LOG.trace("Writing empty file.");
                try {
                    this.writeFileEmptyBody(file);
                    return true;
                }
                catch (IOException e) {
                    throw new GenericFileOperationFailedException("Cannot store file: " + file, e);
                }
            }
            throw new GenericFileOperationFailedException("Cannot write null body to file: " + file);
        }
        try {
            Closeable in;
            String charset = this.endpoint.getCharset();
            File source = null;
            boolean fileBased = false;
            if (charset == null) {
                Object body = exchange.getIn().getBody();
                if (body instanceof WrappedFile) {
                    body = ((WrappedFile)body).getFile();
                    fileBased = true;
                }
                if (body instanceof File) {
                    source = (File)body;
                }
            }
            if (fileBased) {
                File local = exchange.getIn().getHeader("CamelFileLocalWorkPath", File.class);
                if (local != null && local.exists()) {
                    boolean renamed = this.writeFileByLocalWorkPath(local, file);
                    if (renamed) {
                        this.keepLastModified(exchange, file);
                        exchange.getIn().setHeader("CamelFileLocalWorkPath", null);
                        return true;
                    }
                } else if (source != null && source.exists()) {
                    this.writeFileByFile(source, file);
                    this.keepLastModified(exchange, file);
                    return true;
                }
            }
            if (charset != null) {
                in = exchange.getIn().getBody(Reader.class);
                if (in == null) {
                    InputStream is = exchange.getIn().getMandatoryBody(InputStream.class);
                    in = new InputStreamReader(is);
                }
                in = IOHelper.buffered(in);
                this.writeFileByReaderWithCharset((Reader)in, file, charset);
            } else {
                in = exchange.getIn().getMandatoryBody(InputStream.class);
                this.writeFileByStream((InputStream)in, file);
            }
            this.keepLastModified(exchange, file);
            return true;
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + file, e);
        }
        catch (InvalidPayloadException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + file, e);
        }
    }

    private void doMoveExistingFile(String fileName) throws GenericFileOperationFailedException {
        Exchange dummy = this.endpoint.createExchange();
        String parent = FileUtil.onlyPath(fileName);
        String onlyName = FileUtil.stripPath(fileName);
        dummy.getIn().setHeader("CamelFileName", fileName);
        dummy.getIn().setHeader("CamelFileNameOnly", onlyName);
        dummy.getIn().setHeader("CamelFileParent", parent);
        String to = this.endpoint.getMoveExisting().evaluate(dummy, String.class);
        to = FileUtil.normalizePath(to);
        if (ObjectHelper.isEmpty(to)) {
            throw new GenericFileOperationFailedException("moveExisting evaluated as empty String, cannot move existing file: " + fileName);
        }
        File toFile = new File(to);
        String directory = toFile.getParent();
        boolean absolute = FileUtil.isAbsolute(toFile);
        if (directory != null && !this.buildDirectory(directory, absolute)) {
            LOG.debug("Cannot build directory [{}] (could be because of denied permissions)", (Object)directory);
        }
        if (this.existsFile(to)) {
            if (this.endpoint.isEagerDeleteTargetFile()) {
                LOG.trace("Deleting existing file: {}", (Object)to);
                if (!this.deleteFile(to)) {
                    throw new GenericFileOperationFailedException("Cannot delete file: " + to);
                }
            } else {
                throw new GenericFileOperationFailedException("Cannot moved existing file from: " + fileName + " to: " + to + " as there already exists a file: " + to);
            }
        }
        LOG.trace("Moving existing file: {} to: {}", (Object)fileName, (Object)to);
        if (!this.renameFile(fileName, to)) {
            throw new GenericFileOperationFailedException("Cannot rename file from: " + fileName + " to: " + to);
        }
    }

    private void keepLastModified(Exchange exchange, File file) {
        Date date;
        Long last;
        if (this.endpoint.isKeepLastModified() && (last = (date = exchange.getIn().getHeader("CamelFileLastModified", Date.class)) != null ? Long.valueOf(date.getTime()) : exchange.getIn().getHeader("CamelFileLastModified", Long.class)) != null) {
            boolean result = file.setLastModified(last);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Keeping last modified timestamp: {} on file: {} with result: {}", new Object[]{last, file, result});
            }
        }
    }

    private boolean writeFileByLocalWorkPath(File source, File file) throws IOException {
        LOG.trace("Using local work file being renamed from: {} to: {}", source, (Object)file);
        return FileUtil.renameFile(source, file, this.endpoint.isCopyAndDeleteOnRenameFail());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByFile(File source, File target) throws IOException {
        FileChannel in = new FileInputStream(source).getChannel();
        FileChannel out = null;
        try {
            out = this.prepareOutputFileChannel(target);
            LOG.debug("Using FileChannel to write file: {}", target);
            long size = in.size();
            for (long position = 0L; position < size; position += in.transferTo(position, this.endpoint.getBufferSize(), out)) {
            }
        }
        finally {
            IOHelper.close((Closeable)in, source.getName(), LOG);
            IOHelper.close(out, target.getName(), LOG, this.endpoint.isForceWrites());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByStream(InputStream in, File target) throws IOException {
        FileChannel out = null;
        try {
            int bytesRead;
            out = this.prepareOutputFileChannel(target);
            LOG.debug("Using InputStream to write file: {}", target);
            int size = this.endpoint.getBufferSize();
            byte[] buffer = new byte[size];
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            while ((bytesRead = in.read(buffer)) != -1) {
                if (bytesRead < size) {
                    byteBuffer.limit(bytesRead);
                }
                out.write(byteBuffer);
                byteBuffer.clear();
            }
        }
        finally {
            IOHelper.close((Closeable)in, target.getName(), LOG);
            IOHelper.close(out, target.getName(), LOG, this.endpoint.isForceWrites());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByReaderWithCharset(Reader in, File target, String charset) throws IOException {
        boolean append = this.endpoint.getFileExist() == GenericFileExist.Append;
        FileOutputStream os = new FileOutputStream(target, append);
        BufferedWriter out = IOConverter.toWriter(os, charset);
        try {
            LOG.debug("Using Reader to write file: {} with charset: {}", target, (Object)charset);
            int size = this.endpoint.getBufferSize();
            IOHelper.copy(in, out, size);
        }
        finally {
            IOHelper.close((Closeable)in, target.getName(), LOG);
            IOHelper.close(out, os, target.getName(), LOG, this.endpoint.isForceWrites());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileEmptyBody(File target) throws IOException {
        if (!target.exists()) {
            LOG.debug("Creating new empty file: {}", target);
            FileUtil.createNewFile(target);
        } else if (this.endpoint.getFileExist() == GenericFileExist.Override) {
            LOG.debug("Truncating existing file: {}", target);
            FileChannel out = new FileOutputStream(target).getChannel();
            try {
                out.truncate(0L);
            }
            finally {
                IOHelper.close(out, target.getName(), LOG, this.endpoint.isForceWrites());
            }
        }
    }

    private FileChannel prepareOutputFileChannel(File target) throws IOException {
        if (this.endpoint.getFileExist() == GenericFileExist.Append) {
            FileChannel out = new RandomAccessFile(target, "rw").getChannel();
            return out.position(out.size());
        }
        return new FileOutputStream(target).getChannel();
    }
}

