/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.weaver.tools.JoinPointMatch;
import org.aspectj.weaver.tools.PointcutParameter;
import org.springframework.aop.AopInvocationException;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.aspectj.AspectInstanceFactory;
import org.springframework.aop.aspectj.AspectJAdviceParameterNameDiscoverer;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.AspectJPrecedenceInformation;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.MethodMatchers;
import org.springframework.aop.support.StaticMethodMatcher;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.PrioritizedParameterNameDiscoverer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractAspectJAdvice
implements Advice,
AspectJPrecedenceInformation {
    protected static final String JOIN_POINT_KEY = JoinPoint.class.getName();
    protected final Method aspectJAdviceMethod;
    private final int adviceInvocationArgumentCount;
    private final AspectJExpressionPointcut pointcut;
    private final AspectInstanceFactory aspectInstanceFactory;
    private String aspectName;
    private int declarationOrder;
    private String[] argumentNames = null;
    private String throwingName = null;
    private String returningName = null;
    private Class discoveredReturningType = Object.class;
    private Class discoveredThrowingType = Object.class;
    private int joinPointArgumentIndex = -1;
    private int joinPointStaticPartArgumentIndex = -1;
    private Map<String, Integer> argumentBindings = null;
    private boolean argumentsIntrospected = false;
    private Type discoveredReturningGenericType;

    public static JoinPoint currentJoinPoint() {
        MethodInvocation mi = ExposeInvocationInterceptor.currentInvocation();
        if (!(mi instanceof ProxyMethodInvocation)) {
            throw new IllegalStateException("MethodInvocation is not a Spring ProxyMethodInvocation: " + mi);
        }
        ProxyMethodInvocation pmi = (ProxyMethodInvocation)mi;
        Object jp = (JoinPoint)pmi.getUserAttribute(JOIN_POINT_KEY);
        if (jp == null) {
            jp = new MethodInvocationProceedingJoinPoint(pmi);
            pmi.setUserAttribute(JOIN_POINT_KEY, jp);
        }
        return jp;
    }

    public AbstractAspectJAdvice(Method aspectJAdviceMethod, AspectJExpressionPointcut pointcut, AspectInstanceFactory aspectInstanceFactory) {
        Assert.notNull(aspectJAdviceMethod, "Advice method must not be null");
        this.aspectJAdviceMethod = aspectJAdviceMethod;
        this.adviceInvocationArgumentCount = this.aspectJAdviceMethod.getParameterTypes().length;
        this.pointcut = pointcut;
        this.aspectInstanceFactory = aspectInstanceFactory;
    }

    public final Method getAspectJAdviceMethod() {
        return this.aspectJAdviceMethod;
    }

    public final AspectJExpressionPointcut getPointcut() {
        this.calculateArgumentBindings();
        return this.pointcut;
    }

    public final Pointcut buildSafePointcut() {
        AspectJExpressionPointcut pc = this.getPointcut();
        MethodMatcher safeMethodMatcher = MethodMatchers.intersection(new AdviceExcludingMethodMatcher(this.aspectJAdviceMethod), pc.getMethodMatcher());
        return new ComposablePointcut(pc.getClassFilter(), safeMethodMatcher);
    }

    public final AspectInstanceFactory getAspectInstanceFactory() {
        return this.aspectInstanceFactory;
    }

    public final ClassLoader getAspectClassLoader() {
        return this.aspectInstanceFactory.getAspectClassLoader();
    }

    public int getOrder() {
        return this.aspectInstanceFactory.getOrder();
    }

    public void setAspectName(String name) {
        this.aspectName = name;
    }

    public String getAspectName() {
        return this.aspectName;
    }

    public void setDeclarationOrder(int order) {
        this.declarationOrder = order;
    }

    public int getDeclarationOrder() {
        return this.declarationOrder;
    }

    public void setArgumentNames(String argNames) {
        String[] tokens = StringUtils.commaDelimitedListToStringArray(argNames);
        this.setArgumentNamesFromStringArray(tokens);
    }

    public void setArgumentNamesFromStringArray(String[] args) {
        Class<?> firstArgType;
        this.argumentNames = new String[args.length];
        int i = 0;
        while (i < args.length) {
            this.argumentNames[i] = StringUtils.trimWhitespace(args[i]);
            if (!this.isVariableName(this.argumentNames[i])) {
                throw new IllegalArgumentException("'argumentNames' property of AbstractAspectJAdvice contains an argument name '" + this.argumentNames[i] + "' that is not a valid Java identifier");
            }
            ++i;
        }
        if (this.argumentNames != null && this.aspectJAdviceMethod.getParameterTypes().length == this.argumentNames.length + 1 && ((firstArgType = this.aspectJAdviceMethod.getParameterTypes()[0]) == JoinPoint.class || firstArgType == ProceedingJoinPoint.class || firstArgType == JoinPoint.StaticPart.class)) {
            String[] oldNames = this.argumentNames;
            this.argumentNames = new String[oldNames.length + 1];
            this.argumentNames[0] = "THIS_JOIN_POINT";
            System.arraycopy(oldNames, 0, this.argumentNames, 1, oldNames.length);
        }
    }

    public void setReturningName(String name) {
        throw new UnsupportedOperationException("Only afterReturning advice can be used to bind a return value");
    }

    protected void setReturningNameNoCheck(String name) {
        if (this.isVariableName(name)) {
            this.returningName = name;
        } else {
            try {
                this.discoveredReturningType = ClassUtils.forName(name, this.getAspectClassLoader());
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Returning name '" + name + "' is neither a valid argument name nor the fully-qualified name of a Java type on the classpath. " + "Root cause: " + ex);
            }
        }
    }

    protected Class getDiscoveredReturningType() {
        return this.discoveredReturningType;
    }

    protected Type getDiscoveredReturningGenericType() {
        return this.discoveredReturningGenericType;
    }

    public void setThrowingName(String name) {
        throw new UnsupportedOperationException("Only afterThrowing advice can be used to bind a thrown exception");
    }

    protected void setThrowingNameNoCheck(String name) {
        if (this.isVariableName(name)) {
            this.throwingName = name;
        } else {
            try {
                this.discoveredThrowingType = ClassUtils.forName(name, this.getAspectClassLoader());
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Throwing name '" + name + "' is neither a valid argument name nor the fully-qualified name of a Java type on the classpath. " + "Root cause: " + ex);
            }
        }
    }

    protected Class getDiscoveredThrowingType() {
        return this.discoveredThrowingType;
    }

    private boolean isVariableName(String name) {
        char[] chars = name.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        int i = 1;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final synchronized void calculateArgumentBindings() {
        if (this.argumentsIntrospected || this.adviceInvocationArgumentCount == 0) {
            return;
        }
        int numUnboundArgs = this.adviceInvocationArgumentCount;
        Class<?>[] parameterTypes = this.aspectJAdviceMethod.getParameterTypes();
        if (this.maybeBindJoinPoint(parameterTypes[0]) || this.maybeBindProceedingJoinPoint(parameterTypes[0])) {
            --numUnboundArgs;
        } else if (this.maybeBindJoinPointStaticPart(parameterTypes[0])) {
            --numUnboundArgs;
        }
        if (numUnboundArgs > 0) {
            this.bindArgumentsByName(numUnboundArgs);
        }
        this.argumentsIntrospected = true;
    }

    private boolean maybeBindJoinPoint(Class candidateParameterType) {
        if (candidateParameterType.equals(JoinPoint.class)) {
            this.joinPointArgumentIndex = 0;
            return true;
        }
        return false;
    }

    private boolean maybeBindProceedingJoinPoint(Class candidateParameterType) {
        if (candidateParameterType.equals(ProceedingJoinPoint.class)) {
            if (!this.supportsProceedingJoinPoint()) {
                throw new IllegalArgumentException("ProceedingJoinPoint is only supported for around advice");
            }
            this.joinPointArgumentIndex = 0;
            return true;
        }
        return false;
    }

    protected boolean supportsProceedingJoinPoint() {
        return false;
    }

    private boolean maybeBindJoinPointStaticPart(Class candidateParameterType) {
        if (candidateParameterType.equals(JoinPoint.StaticPart.class)) {
            this.joinPointStaticPartArgumentIndex = 0;
            return true;
        }
        return false;
    }

    private void bindArgumentsByName(int numArgumentsExpectingToBind) {
        if (this.argumentNames == null) {
            this.argumentNames = this.createParameterNameDiscoverer().getParameterNames(this.aspectJAdviceMethod);
        }
        if (this.argumentNames == null) {
            throw new IllegalStateException("Advice method [" + this.aspectJAdviceMethod.getName() + "] " + "requires " + numArgumentsExpectingToBind + " arguments to be bound by name, but " + "the argument names were not specified and could not be discovered.");
        }
        this.bindExplicitArguments(numArgumentsExpectingToBind);
    }

    protected ParameterNameDiscoverer createParameterNameDiscoverer() {
        PrioritizedParameterNameDiscoverer discoverer = new PrioritizedParameterNameDiscoverer();
        discoverer.addDiscoverer(new LocalVariableTableParameterNameDiscoverer());
        AspectJAdviceParameterNameDiscoverer adviceParameterNameDiscoverer = new AspectJAdviceParameterNameDiscoverer(this.pointcut.getExpression());
        adviceParameterNameDiscoverer.setReturningName(this.returningName);
        adviceParameterNameDiscoverer.setThrowingName(this.throwingName);
        adviceParameterNameDiscoverer.setRaiseExceptions(true);
        discoverer.addDiscoverer(adviceParameterNameDiscoverer);
        return discoverer;
    }

    private void bindExplicitArguments(int numArgumentsLeftToBind) {
        int argumentIndexOffset;
        this.argumentBindings = new HashMap<String, Integer>();
        int numExpectedArgumentNames = this.aspectJAdviceMethod.getParameterTypes().length;
        if (this.argumentNames.length != numExpectedArgumentNames) {
            throw new IllegalStateException("Expecting to find " + numExpectedArgumentNames + " arguments to bind by name in advice, but actually found " + this.argumentNames.length + " arguments.");
        }
        int i = argumentIndexOffset = this.adviceInvocationArgumentCount - numArgumentsLeftToBind;
        while (i < this.argumentNames.length) {
            this.argumentBindings.put(this.argumentNames[i], i);
            ++i;
        }
        if (this.returningName != null) {
            if (!this.argumentBindings.containsKey(this.returningName)) {
                throw new IllegalStateException("Returning argument name '" + this.returningName + "' was not bound in advice arguments");
            }
            Integer index = this.argumentBindings.get(this.returningName);
            this.discoveredReturningType = this.aspectJAdviceMethod.getParameterTypes()[index];
            this.discoveredReturningGenericType = this.aspectJAdviceMethod.getGenericParameterTypes()[index];
        }
        if (this.throwingName != null) {
            if (!this.argumentBindings.containsKey(this.throwingName)) {
                throw new IllegalStateException("Throwing argument name '" + this.throwingName + "' was not bound in advice arguments");
            }
            Integer index = this.argumentBindings.get(this.throwingName);
            this.discoveredThrowingType = this.aspectJAdviceMethod.getParameterTypes()[index];
        }
        this.configurePointcutParameters(argumentIndexOffset);
    }

    private void configurePointcutParameters(int argumentIndexOffset) {
        int numParametersToRemove = argumentIndexOffset;
        if (this.returningName != null) {
            ++numParametersToRemove;
        }
        if (this.throwingName != null) {
            ++numParametersToRemove;
        }
        String[] pointcutParameterNames = new String[this.argumentNames.length - numParametersToRemove];
        Class[] pointcutParameterTypes = new Class[pointcutParameterNames.length];
        Class<?>[] methodParameterTypes = this.aspectJAdviceMethod.getParameterTypes();
        int index = 0;
        int i = 0;
        while (i < this.argumentNames.length) {
            if (i >= argumentIndexOffset && !this.argumentNames[i].equals(this.returningName) && !this.argumentNames[i].equals(this.throwingName)) {
                pointcutParameterNames[index] = this.argumentNames[i];
                pointcutParameterTypes[index] = methodParameterTypes[i];
                ++index;
            }
            ++i;
        }
        this.pointcut.setParameterNames(pointcutParameterNames);
        this.pointcut.setParameterTypes(pointcutParameterTypes);
    }

    protected Object[] argBinding(JoinPoint jp, JoinPointMatch jpMatch, Object returnValue, Throwable ex) {
        this.calculateArgumentBindings();
        Object[] adviceInvocationArgs = new Object[this.adviceInvocationArgumentCount];
        int numBound = 0;
        if (this.joinPointArgumentIndex != -1) {
            adviceInvocationArgs[this.joinPointArgumentIndex] = jp;
            ++numBound;
        } else if (this.joinPointStaticPartArgumentIndex != -1) {
            adviceInvocationArgs[this.joinPointStaticPartArgumentIndex] = jp.getStaticPart();
            ++numBound;
        }
        if (!CollectionUtils.isEmpty(this.argumentBindings)) {
            Integer index;
            if (jpMatch != null) {
                PointcutParameter[] parameterBindings;
                PointcutParameter[] pointcutParameterArray = parameterBindings = jpMatch.getParameterBindings();
                int n = parameterBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    PointcutParameter parameter = pointcutParameterArray[n2];
                    String name = parameter.getName();
                    Integer index2 = this.argumentBindings.get(name);
                    adviceInvocationArgs[index2.intValue()] = parameter.getBinding();
                    ++numBound;
                    ++n2;
                }
            }
            if (this.returningName != null) {
                index = this.argumentBindings.get(this.returningName);
                adviceInvocationArgs[index.intValue()] = returnValue;
                ++numBound;
            }
            if (this.throwingName != null) {
                index = this.argumentBindings.get(this.throwingName);
                adviceInvocationArgs[index.intValue()] = ex;
                ++numBound;
            }
        }
        if (numBound != this.adviceInvocationArgumentCount) {
            throw new IllegalStateException("Required to bind " + this.adviceInvocationArgumentCount + " arguments, but only bound " + numBound + " (JoinPointMatch " + (jpMatch == null ? "was NOT" : "WAS") + " bound in invocation)");
        }
        return adviceInvocationArgs;
    }

    protected Object invokeAdviceMethod(JoinPointMatch jpMatch, Object returnValue, Throwable ex) throws Throwable {
        return this.invokeAdviceMethodWithGivenArgs(this.argBinding(this.getJoinPoint(), jpMatch, returnValue, ex));
    }

    protected Object invokeAdviceMethod(JoinPoint jp, JoinPointMatch jpMatch, Object returnValue, Throwable t) throws Throwable {
        return this.invokeAdviceMethodWithGivenArgs(this.argBinding(jp, jpMatch, returnValue, t));
    }

    protected Object invokeAdviceMethodWithGivenArgs(Object[] args) throws Throwable {
        Object[] actualArgs = args;
        if (this.aspectJAdviceMethod.getParameterTypes().length == 0) {
            actualArgs = null;
        }
        try {
            ReflectionUtils.makeAccessible(this.aspectJAdviceMethod);
            return this.aspectJAdviceMethod.invoke(this.aspectInstanceFactory.getAspectInstance(), actualArgs);
        }
        catch (IllegalArgumentException ex) {
            throw new AopInvocationException("Mismatch on arguments to advice method [" + this.aspectJAdviceMethod + "]; pointcut expression [" + this.pointcut.getPointcutExpression() + "]", ex);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    protected JoinPoint getJoinPoint() {
        return AbstractAspectJAdvice.currentJoinPoint();
    }

    protected JoinPointMatch getJoinPointMatch() {
        MethodInvocation mi = ExposeInvocationInterceptor.currentInvocation();
        if (!(mi instanceof ProxyMethodInvocation)) {
            throw new IllegalStateException("MethodInvocation is not a Spring ProxyMethodInvocation: " + mi);
        }
        return this.getJoinPointMatch((ProxyMethodInvocation)mi);
    }

    protected JoinPointMatch getJoinPointMatch(ProxyMethodInvocation pmi) {
        return (JoinPointMatch)pmi.getUserAttribute(this.pointcut.getExpression());
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": advice method [" + this.aspectJAdviceMethod + "]; " + "aspect name '" + this.aspectName + "'";
    }

    private static class AdviceExcludingMethodMatcher
    extends StaticMethodMatcher {
        private final Method adviceMethod;

        public AdviceExcludingMethodMatcher(Method adviceMethod) {
            this.adviceMethod = adviceMethod;
        }

        public boolean matches(Method method, Class targetClass) {
            return !this.adviceMethod.equals(method);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AdviceExcludingMethodMatcher)) {
                return false;
            }
            AdviceExcludingMethodMatcher otherMm = (AdviceExcludingMethodMatcher)other;
            return this.adviceMethod.equals(otherMm.adviceMethod);
        }

        public int hashCode() {
            return this.adviceMethod.hashCode();
        }
    }
}

