/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.support.ServiceSupport;

public class SortProcessor<T>
extends ServiceSupport
implements Processor {
    private final Expression expression;
    private final Comparator<? super T> comparator;

    public SortProcessor(Expression expression, Comparator<? super T> comparator) {
        this.expression = expression;
        this.comparator = comparator;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        List list = this.expression.evaluate(exchange, List.class);
        Collections.sort(list, this.comparator);
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(in);
            out.setBody(list);
        } else {
            in.setBody(list);
        }
    }

    public String toString() {
        return "Sort[" + this.expression + "]";
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

