/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ServiceHelper;

public class ChoiceProcessor
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor>,
Traceable {
    private final List<Processor> filters;
    private final Processor otherwise;

    public ChoiceProcessor(List<Processor> filters, Processor otherwise) {
        this.filters = filters;
        this.otherwise = otherwise;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Iterator<Processor> processors = this.next().iterator();
        final Object existing = exchange.getProperty("CamelFilterMatched");
        AsyncCallback choiceCallback = new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (existing != null) {
                    exchange.setProperty("CamelFilterMatched", existing);
                } else {
                    exchange.removeProperty("CamelFilterMatched");
                }
                callback.done(doneSync);
            }
        };
        while (processors.hasNext()) {
            Processor processor = processors.next();
            boolean matches = true;
            if (processor instanceof FilterProcessor) {
                FilterProcessor filter = (FilterProcessor)processor;
                try {
                    matches = filter.getPredicate().matches(exchange);
                    exchange.setProperty("CamelFilterMatched", matches);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                    choiceCallback.done(true);
                    return true;
                }
                processor = filter.getProcessor();
            }
            if (!matches) continue;
            AsyncProcessor async = AsyncProcessorConverterHelper.convert(processor);
            return async.process(exchange, choiceCallback);
        }
        choiceCallback.done(true);
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("choice{");
        boolean first = true;
        for (Processor processor : this.filters) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("when ");
            builder.append(processor);
        }
        if (this.otherwise != null) {
            builder.append(", otherwise: ");
            builder.append(this.otherwise);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getTraceLabel() {
        return "choice";
    }

    public List<Processor> getFilters() {
        return this.filters;
    }

    public Processor getOtherwise() {
        return this.otherwise;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        if (this.filters != null) {
            answer.addAll(this.filters);
        }
        if (this.otherwise != null) {
            answer.add(this.otherwise);
        }
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.otherwise != null || this.filters != null && !this.filters.isEmpty();
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.filters, this.otherwise);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.otherwise, this.filters);
    }
}

