/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.ServiceSupport;

public abstract class DefaultRoute
extends ServiceSupport
implements Route {
    private final Endpoint endpoint;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<Service> services = new ArrayList<Service>();
    private final RouteContext routeContext;

    public DefaultRoute(RouteContext routeContext, Endpoint endpoint) {
        this.routeContext = routeContext;
        this.endpoint = endpoint;
    }

    public DefaultRoute(RouteContext routeContext, Endpoint endpoint, Service ... services) {
        this(routeContext, endpoint);
        for (Service service : services) {
            this.addService(service);
        }
    }

    public String toString() {
        return "Route " + this.getId();
    }

    @Override
    public String getId() {
        return (String)this.properties.get("id");
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void onStartingServices(List<Service> services) throws Exception {
        this.addServices(services);
    }

    @Override
    public List<Service> getServices() {
        return this.services;
    }

    @Override
    public void addService(Service service) {
        if (!this.services.contains(service)) {
            this.services.add(service);
        }
    }

    @Override
    public void warmUp() {
        this.getServices().clear();
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
    }

    protected void addServices(List<Service> services) throws Exception {
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        this.services.clear();
    }
}

