/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.component.seda.SedaComponent;

public class VmComponent
extends SedaComponent {
    protected static final Map<String, SedaComponent.QueueReference> QUEUES = new HashMap<String, SedaComponent.QueueReference>();
    private static final AtomicInteger START_COUNTER = new AtomicInteger();

    @Override
    public Map<String, SedaComponent.QueueReference> getQueues() {
        return QUEUES;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        START_COUNTER.incrementAndGet();
    }

    @Override
    protected void doStop() throws Exception {
        if (START_COUNTER.decrementAndGet() <= 0) {
            this.getQueues().clear();
        }
    }
}

