/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import javax.jms.JMSException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.pool.PooledSession;
import org.apache.activemq.pool.XaConnectionPool;
import org.apache.activemq.ra.LocalAndXATransaction;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;

public class JcaConnectionPool
extends XaConnectionPool {
    private final String name;

    public JcaConnectionPool(ActiveMQConnection connection, TransactionManager transactionManager, String name) {
        super(connection, transactionManager);
        this.name = name;
    }

    @Override
    protected XAResource createXaResource(PooledSession session) throws JMSException {
        LocalAndXATransaction xares = new LocalAndXATransaction(session.getInternalSession().getTransactionContext());
        if (this.name != null) {
            xares = new WrapperNamedXAResource((XAResource)xares, this.name);
        }
        return xares;
    }
}

