/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.List;
import java.util.Map;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spring.SpringCamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ContextScanRouteBuilderFinder {
    private static final transient Logger LOG = LoggerFactory.getLogger(ContextScanRouteBuilderFinder.class);
    private final ApplicationContext applicationContext;
    private final PackageScanFilter filter;

    public ContextScanRouteBuilderFinder(SpringCamelContext camelContext, PackageScanFilter filter) {
        this.applicationContext = camelContext.getApplicationContext();
        this.filter = filter;
    }

    public void appendBuilders(List<RoutesBuilder> list) {
        Map<String, RoutesBuilder> beans = this.applicationContext.getBeansOfType(RoutesBuilder.class, true, true);
        for (Map.Entry<String, RoutesBuilder> entry : beans.entrySet()) {
            RoutesBuilder bean = entry.getValue();
            String key = entry.getKey();
            LOG.trace("Found RouteBuilder with id: {} -> {}", (Object)key, (Object)bean);
            if (this.shouldIgnoreBean(bean)) {
                LOG.debug("Ignoring RouteBuilder id: {}", (Object)key);
                continue;
            }
            if (!this.isFilteredClass(bean)) {
                LOG.debug("Ignoring filtered RouteBuilder id: {} as class: {}", (Object)key, bean.getClass());
                continue;
            }
            LOG.debug("Adding instantiated RouteBuilder id: {} as class: {}", (Object)key, bean.getClass());
            list.add(bean);
        }
    }

    protected boolean shouldIgnoreBean(Object bean) {
        return false;
    }

    protected boolean isFilteredClass(Object bean) {
        if (this.filter != null) {
            return this.filter.matches(bean.getClass());
        }
        return false;
    }
}

