/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.util.ServiceHelper;

public class DefaultScheduledPollConsumer
extends ScheduledPollConsumer {
    private PollingConsumer pollingConsumer;

    public DefaultScheduledPollConsumer(DefaultEndpoint defaultEndpoint, Processor processor) {
        super(defaultEndpoint, processor);
    }

    public DefaultScheduledPollConsumer(Endpoint endpoint, Processor processor, ScheduledExecutorService executor) {
        super(endpoint, processor, executor);
    }

    @Override
    protected int poll() throws Exception {
        Exchange exchange;
        int messagesPolled = 0;
        while (this.isPollAllowed() && (exchange = this.pollingConsumer.receiveNoWait()) != null) {
            this.log.trace("Polled {} {}", ++messagesPolled, (Object)exchange);
            if (exchange.hasOut()) {
                Exchange newExchange = this.getEndpoint().createExchange();
                newExchange.getIn().copyFrom(exchange.getOut());
                exchange = newExchange;
            }
            this.getProcessor().process(exchange);
        }
        return messagesPolled;
    }

    @Override
    protected void doStart() throws Exception {
        this.pollingConsumer = this.getEndpoint().createPollingConsumer();
        ServiceHelper.startService(this.pollingConsumer);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.pollingConsumer);
        super.doStop();
    }
}

