/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.stream.StreamEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamConsumer
extends DefaultConsumer
implements Runnable {
    private static final transient Logger LOG = LoggerFactory.getLogger(StreamConsumer.class);
    private static final String TYPES = "in,file,url";
    private static final String INVALID_URI = "Invalid uri, valid form: 'stream:{in,file,url}'";
    private static final List<String> TYPES_LIST = Arrays.asList("in,file,url".split(","));
    private ExecutorService executor;
    private volatile InputStream inputStream = System.in;
    private volatile InputStream inputStreamToClose;
    private StreamEndpoint endpoint;
    private String uri;
    private boolean initialPromptDone;
    private final List<String> lines = new CopyOnWriteArrayList<String>();

    public StreamConsumer(StreamEndpoint endpoint, Processor processor, String uri) throws Exception {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.uri = uri;
        this.validateUri(uri);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.initializeStream();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor(this, this.endpoint.getEndpointUri());
        this.executor.execute(this);
        if (this.endpoint.getGroupLines() < 0) {
            throw new IllegalArgumentException("Option groupLines must be 0 or positive number, was " + this.endpoint.getGroupLines());
        }
    }

    @Override
    public void doStop() throws Exception {
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
        this.lines.clear();
        IOHelper.close((Closeable)this.inputStreamToClose);
        super.doStop();
    }

    @Override
    public void run() {
        try {
            this.readFromStream();
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException(e);
        }
    }

    private BufferedReader initializeStream() throws Exception {
        IOHelper.close((Closeable)this.inputStreamToClose);
        if ("in".equals(this.uri)) {
            this.inputStream = System.in;
            this.inputStreamToClose = null;
        } else if ("file".equals(this.uri)) {
            this.inputStreamToClose = this.inputStream = this.resolveStreamFromFile();
        } else if ("url".equals(this.uri)) {
            this.inputStreamToClose = this.inputStream = this.resolveStreamFromUrl();
        }
        Charset charset = this.endpoint.getCharset();
        return IOHelper.buffered(new InputStreamReader(this.inputStream, charset));
    }

    private void readFromStream() throws Exception {
        BufferedReader br = this.initializeStream();
        if (this.endpoint.isScanStream()) {
            while (this.isRunAllowed()) {
                boolean eos;
                String line = br.readLine();
                LOG.trace("Read line: {}", (Object)line);
                boolean bl = eos = line == null;
                if (!eos && this.isRunAllowed()) {
                    this.processLine(line);
                } else if (eos && this.isRunAllowed() && this.endpoint.isRetry()) {
                    br = this.initializeStream();
                }
                try {
                    Thread.sleep(this.endpoint.getScanStreamDelay());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        } else {
            boolean eos = false;
            while (!eos && this.isRunAllowed()) {
                if (this.endpoint.getPromptMessage() != null) {
                    this.doPromptMessage();
                }
                String line = br.readLine();
                LOG.trace("Read line: {}", (Object)line);
                eos = line == null;
                if (eos || !this.isRunAllowed()) continue;
                this.processLine(line);
            }
        }
    }

    protected synchronized void processLine(String line) throws Exception {
        if (this.endpoint.getGroupLines() > 0) {
            this.lines.add(line);
            if (this.lines.size() >= this.endpoint.getGroupLines()) {
                Exchange exchange = this.endpoint.createExchange();
                DefaultMessage msg = new DefaultMessage();
                ArrayList<String> copy = new ArrayList<String>(this.lines);
                msg.setBody(this.endpoint.getGroupStrategy().groupLines(copy));
                exchange.setIn(msg);
                this.lines.clear();
                this.getProcessor().process(exchange);
            }
        } else {
            Exchange exchange = this.endpoint.createExchange();
            DefaultMessage msg = new DefaultMessage();
            msg.setBody(line);
            exchange.setIn(msg);
            this.getProcessor().process(exchange);
        }
    }

    protected void doPromptMessage() {
        long delay = 0L;
        if (!this.initialPromptDone && this.endpoint.getInitialPromptDelay() > 0L) {
            this.initialPromptDone = true;
            delay = this.endpoint.getInitialPromptDelay();
        } else if (this.endpoint.getPromptDelay() > 0L) {
            delay = this.endpoint.getPromptDelay();
        }
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.inputStream == System.in) {
            System.out.print(this.endpoint.getPromptMessage());
        }
    }

    private InputStream resolveStreamFromUrl() throws IOException {
        String u = this.endpoint.getUrl();
        ObjectHelper.notEmpty(u, "url");
        LOG.debug("About to read from url: {}", (Object)u);
        URL url = new URL(u);
        URLConnection c = url.openConnection();
        return c.getInputStream();
    }

    private InputStream resolveStreamFromFile() throws IOException {
        String fileName = this.endpoint.getFileName();
        ObjectHelper.notEmpty(fileName, "fileName");
        File file = new File(fileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("File to be scanned : {}, path : {}", (Object)file.getName(), (Object)file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        FileInputStream fileStream = new FileInputStream(file);
        return fileStream;
    }

    private void validateUri(String uri) throws IllegalArgumentException {
        String[] s = uri.split(":");
        if (s.length < 2) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        String[] t = s[1].split("\\?");
        if (t.length < 1) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        this.uri = t[0].trim();
        if (this.uri.startsWith("//")) {
            this.uri = this.uri.substring(2);
        }
        if (!TYPES_LIST.contains(this.uri)) {
            throw new IllegalArgumentException(INVALID_URI);
        }
    }
}

