/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.stream.log;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.iq80.snappy.Snappy;

public class SnappyCompressor
implements Processor {
    @Override
    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        if (in.getBody() != null) {
            byte[] data = in.getMandatoryBody(byte[].class);
            byte[] compressed = this.compress(data);
            if (exchange.getPattern().isOutCapable()) {
                Message out = exchange.getOut();
                out.copyFrom(in);
                out.setBody(compressed);
            } else {
                in.setBody(compressed);
            }
        }
    }

    private byte[] compress(byte[] data) {
        byte[] compressed = new byte[Snappy.maxCompressedLength(data.length)];
        int len = Snappy.compress(data, 0, data.length, compressed, 0);
        byte[] result = new byte[len];
        System.arraycopy(compressed, 0, result, 0, len);
        return result;
    }
}

