/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.apache.camel.util.jsse.JsseParameters;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagersParameters
extends JsseParameters {
    private static final Logger LOG = LoggerFactory.getLogger(KeyManagersParameters.class);
    protected KeyStoreParameters keyStore;
    protected String keyPassword;
    protected String provider;
    protected String algorithm;

    public KeyManager[] createKeyManagers() throws GeneralSecurityException, IOException {
        LOG.debug("Creating KeyManager[] from KeyManagersParameters: {}", this);
        String kmfAlgorithm = this.parsePropertyValue(this.getAlgorithm());
        if (kmfAlgorithm == null) {
            kmfAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        KeyManagerFactory kmf = this.getProvider() == null ? KeyManagerFactory.getInstance(kmfAlgorithm) : KeyManagerFactory.getInstance(kmfAlgorithm, this.parsePropertyValue(this.getProvider()));
        char[] kmfPassword = null;
        if (this.getKeyPassword() != null) {
            kmfPassword = this.parsePropertyValue(this.getKeyPassword()).toCharArray();
        }
        KeyStore ks = this.getKeyStore() == null ? null : this.getKeyStore().createKeyStore();
        kmf.init(ks, kmfPassword);
        KeyManager[] keyManagers = kmf.getKeyManagers();
        return keyManagers;
    }

    public KeyStoreParameters getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStoreParameters value) {
        this.keyStore = value;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String value) {
        this.keyPassword = value;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String value) {
        this.algorithm = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("KeyManagersParameters [keyStore=");
        builder.append(this.keyStore);
        builder.append(", keyPassword=");
        builder.append("********");
        builder.append(", provider=");
        builder.append(this.provider);
        builder.append(", algorithm=");
        builder.append(this.algorithm);
        builder.append(", getContext()=");
        builder.append(this.getCamelContext());
        builder.append("]");
        return builder.toString();
    }
}

