/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.remoting;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.spring.util.CamelContextResolverHelper;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.support.RemoteExporter;

public class CamelServiceExporter
extends RemoteExporter
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
CamelContextAware {
    private String uri;
    private CamelContext camelContext;
    private String camelContextId;
    private Consumer consumer;
    private String serviceRef;
    private ApplicationContext applicationContext;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setCamelContextId(String camelContextId) {
        this.camelContextId = camelContextId;
    }

    public String getServiceRef() {
        return this.serviceRef;
    }

    public void setServiceRef(String serviceRef) {
        this.serviceRef = serviceRef;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        ObjectHelper.notNull(this.uri, "uri");
        if (this.camelContext == null && this.camelContextId != null) {
            this.camelContext = CamelContextResolverHelper.getCamelContextWithId(this.applicationContext, this.camelContextId);
        }
        ObjectHelper.notNull(this.camelContext, "camelContext");
        if (this.serviceRef != null && this.getService() == null && this.applicationContext != null) {
            this.setService(this.applicationContext.getBean(this.serviceRef));
        }
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(this.camelContext, this.uri);
        ObjectHelper.notNull(this.getService(), "service");
        Object proxy = this.getProxyForService();
        this.consumer = endpoint.createConsumer(new BeanProcessor(proxy, this.camelContext));
        this.consumer.start();
    }

    @Override
    public void destroy() throws Exception {
        if (this.consumer != null) {
            this.consumer.stop();
        }
    }
}

