/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Service;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.impl.CamelPostProcessorHelper;
import org.apache.camel.impl.DefaultCamelBeanPostProcessor;
import org.apache.camel.spring.GenericBeansException;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@XmlRootElement(name="beanPostProcessor")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelBeanPostProcessor.class);
    @XmlTransient
    Set<String> prototypeBeans = new LinkedHashSet<String>();
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlTransient
    private CamelPostProcessorHelper camelPostProcessorHelper;
    @XmlTransient
    private String camelId;
    @XmlTransient
    private final DefaultCamelBeanPostProcessor delegate = new DefaultCamelBeanPostProcessor(){

        @Override
        public CamelContext getOrLookupCamelContext() {
            if (this.camelContext == null) {
                if (CamelBeanPostProcessor.this.camelId != null) {
                    LOG.trace("Looking up CamelContext by id: {} from Spring ApplicationContext: {}", (Object)CamelBeanPostProcessor.this.camelId, (Object)CamelBeanPostProcessor.this.applicationContext);
                    this.camelContext = CamelBeanPostProcessor.this.applicationContext.getBean(CamelBeanPostProcessor.this.camelId, CamelContext.class);
                } else {
                    LOG.trace("Looking up CamelContext by type from Spring ApplicationContext: {}", CamelBeanPostProcessor.this.applicationContext);
                    Map<String, CamelContext> contexts = CamelBeanPostProcessor.this.applicationContext.getBeansOfType(CamelContext.class);
                    if (contexts != null && contexts.size() == 1) {
                        this.camelContext = contexts.values().iterator().next();
                    }
                }
            }
            return this.camelContext;
        }

        @Override
        public boolean canPostProcessBean(Object bean, String beanName) {
            if (bean == null || bean instanceof CamelJMXAgentDefinition) {
                return false;
            }
            return super.canPostProcessBean(bean, beanName);
        }

        @Override
        public CamelPostProcessorHelper getPostProcessorHelper() {
            if (this.camelPostProcessorHelper == null) {
                this.camelPostProcessorHelper = new CamelPostProcessorHelper(){

                    @Override
                    public CamelContext getCamelContext() {
                        return CamelBeanPostProcessor.this.delegate.getOrLookupCamelContext();
                    }

                    @Override
                    protected RuntimeException createProxyInstantiationRuntimeException(Class<?> type, Endpoint endpoint, Exception e) {
                        return new BeanInstantiationException(type, "Could not instantiate proxy of type " + type.getName() + " on endpoint " + endpoint, e);
                    }

                    @Override
                    protected boolean isSingleton(Object bean, String beanName) {
                        if (CamelBeanPostProcessor.this.applicationContext == null || beanName == null) {
                            return super.isSingleton(bean, beanName);
                        }
                        return CamelBeanPostProcessor.this.applicationContext.isSingleton(beanName);
                    }

                    @Override
                    protected void startService(Service service, Object bean, String beanName) throws Exception {
                        if (this.isSingleton(bean, beanName)) {
                            this.getCamelContext().addService(service);
                        } else {
                            ServiceHelper.startService(service);
                            if (CamelBeanPostProcessor.this.prototypeBeans.add(beanName)) {
                                LOG.warn("The bean with id [" + beanName + "] is prototype scoped and cannot stop the injected service when bean is destroyed: " + service + ". You may want to stop the service manually from the bean.");
                            }
                        }
                    }
                };
            }
            return this.camelPostProcessorHelper;
        }
    };

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        try {
            return this.delegate.postProcessBeforeInitialization(bean, beanName);
        }
        catch (Exception e) {
            if (e instanceof BeansException) {
                throw (BeansException)e;
            }
            throw new GenericBeansException("Error post processing bean: " + beanName, e);
        }
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        try {
            return this.delegate.postProcessAfterInitialization(bean, beanName);
        }
        catch (Exception e) {
            if (e instanceof BeansException) {
                throw (BeansException)e;
            }
            throw new GenericBeansException("Error post processing bean: " + beanName, e);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getCamelId() {
        return this.camelId;
    }

    public void setCamelId(String camelId) {
        this.camelId = camelId;
    }
}

