/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.InflightRepository;

public class RouteInflightRepositoryProcessor
extends DelegateAsyncProcessor {
    private final InflightRepository inflightRepository;
    private Route route;
    private String id;

    public RouteInflightRepositoryProcessor(InflightRepository inflightRepository, Processor processor) {
        super(processor);
        this.inflightRepository = inflightRepository;
    }

    public void setRoute(Route route) {
        this.route = route;
        this.id = route.getId();
    }

    @Override
    protected boolean processNext(final Exchange exchange, final AsyncCallback callback) {
        this.inflightRepository.add(exchange, this.id);
        boolean sync = this.processor.process(exchange, new AsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done(boolean doneSync) {
                try {
                    RouteInflightRepositoryProcessor.this.inflightRepository.remove(exchange, RouteInflightRepositoryProcessor.this.id);
                }
                finally {
                    callback.done(doneSync);
                }
            }
        });
        return sync;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

