/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultUnitOfWork;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCUnitOfWork
extends DefaultUnitOfWork {
    public static final String MDC_BREADCRUMB_ID = "breadcrumbId";
    public static final String MDC_EXCHANGE_ID = "exchangeId";
    public static final String MDC_MESSAGE_ID = "messageId";
    public static final String MDC_CORRELATION_ID = "correlationId";
    public static final String MDC_ROUTE_ID = "routeId";
    public static final String MDC_CAMEL_CONTEXT_ID = "camelContextId";
    public static final String MDC_TRANSACTION_KEY = "transactionKey";
    private static final Logger LOG = LoggerFactory.getLogger(MDCUnitOfWork.class);
    private final String originalBreadcrumbId;
    private final String originalExchangeId = MDC.get("exchangeId");
    private final String originalMessageId = MDC.get("messageId");
    private final String originalCorrelationId;
    private final String originalRouteId;
    private final String originalCamelContextId;
    private final String originalTransactionKey;

    public MDCUnitOfWork(Exchange exchange) {
        super(exchange, LOG);
        String breadcrumbId;
        this.originalBreadcrumbId = MDC.get(MDC_BREADCRUMB_ID);
        this.originalCorrelationId = MDC.get(MDC_CORRELATION_ID);
        this.originalRouteId = MDC.get(MDC_ROUTE_ID);
        this.originalCamelContextId = MDC.get(MDC_CAMEL_CONTEXT_ID);
        this.originalTransactionKey = MDC.get(MDC_TRANSACTION_KEY);
        MDC.put(MDC_EXCHANGE_ID, exchange.getExchangeId());
        String msgId = exchange.hasOut() ? exchange.getOut().getMessageId() : exchange.getIn().getMessageId();
        MDC.put(MDC_MESSAGE_ID, msgId);
        MDC.put(MDC_CAMEL_CONTEXT_ID, exchange.getContext().getName());
        String corrId = exchange.getProperty("CamelCorrelationId", String.class);
        if (corrId != null) {
            MDC.put(MDC_CORRELATION_ID, corrId);
        }
        if ((breadcrumbId = exchange.getIn().getHeader(MDC_BREADCRUMB_ID, String.class)) != null) {
            MDC.put(MDC_BREADCRUMB_ID, breadcrumbId);
        }
    }

    @Override
    public UnitOfWork newInstance(Exchange exchange) {
        return new MDCUnitOfWork(exchange);
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.clear();
    }

    @Override
    public void pushRouteContext(RouteContext routeContext) {
        MDC.put(MDC_ROUTE_ID, routeContext.getRoute().getId());
        super.pushRouteContext(routeContext);
    }

    @Override
    public RouteContext popRouteContext() {
        MDC.remove(MDC_ROUTE_ID);
        return super.popRouteContext();
    }

    @Override
    public void beginTransactedBy(Object key) {
        MDC.put(MDC_TRANSACTION_KEY, key.toString());
        super.beginTransactedBy(key);
    }

    @Override
    public void endTransactedBy(Object key) {
        MDC.remove(MDC_TRANSACTION_KEY);
        super.endTransactedBy(key);
    }

    @Override
    public AsyncCallback beforeProcess(Processor processor, Exchange exchange, AsyncCallback callback) {
        return new MDCCallback(callback);
    }

    @Override
    public void afterProcess(Processor processor, Exchange exchange, AsyncCallback callback, boolean doneSync) {
        if (!doneSync) {
            this.clear();
        }
        super.afterProcess(processor, exchange, callback, doneSync);
    }

    public void clear() {
        if (this.originalBreadcrumbId != null) {
            MDC.put(MDC_BREADCRUMB_ID, this.originalBreadcrumbId);
        } else {
            MDC.remove(MDC_BREADCRUMB_ID);
        }
        if (this.originalExchangeId != null) {
            MDC.put(MDC_EXCHANGE_ID, this.originalExchangeId);
        } else {
            MDC.remove(MDC_EXCHANGE_ID);
        }
        if (this.originalMessageId != null) {
            MDC.put(MDC_MESSAGE_ID, this.originalMessageId);
        } else {
            MDC.remove(MDC_MESSAGE_ID);
        }
        if (this.originalCorrelationId != null) {
            MDC.put(MDC_CORRELATION_ID, this.originalCorrelationId);
        } else {
            MDC.remove(MDC_CORRELATION_ID);
        }
        if (this.originalRouteId != null) {
            MDC.put(MDC_ROUTE_ID, this.originalRouteId);
        } else {
            MDC.remove(MDC_ROUTE_ID);
        }
        if (this.originalCamelContextId != null) {
            MDC.put(MDC_CAMEL_CONTEXT_ID, this.originalCamelContextId);
        } else {
            MDC.remove(MDC_CAMEL_CONTEXT_ID);
        }
        if (this.originalTransactionKey != null) {
            MDC.put(MDC_TRANSACTION_KEY, this.originalTransactionKey);
        } else {
            MDC.remove(MDC_TRANSACTION_KEY);
        }
    }

    @Override
    public String toString() {
        return "MDCUnitOfWork";
    }

    private static final class MDCCallback
    implements AsyncCallback {
        private final AsyncCallback delegate;
        private final String breadcrumbId;
        private final String exchangeId;
        private final String messageId;
        private final String correlationId;
        private final String routeId;
        private final String camelContextId;

        private MDCCallback(AsyncCallback delegate) {
            this.delegate = delegate;
            this.exchangeId = MDC.get(MDCUnitOfWork.MDC_EXCHANGE_ID);
            this.messageId = MDC.get(MDCUnitOfWork.MDC_MESSAGE_ID);
            this.breadcrumbId = MDC.get(MDCUnitOfWork.MDC_BREADCRUMB_ID);
            this.correlationId = MDC.get(MDCUnitOfWork.MDC_CORRELATION_ID);
            this.camelContextId = MDC.get(MDCUnitOfWork.MDC_CAMEL_CONTEXT_ID);
            String routeId = MDC.get(MDCUnitOfWork.MDC_ROUTE_ID);
            this.routeId = routeId != null ? routeId.intern() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(boolean doneSync) {
            try {
                if (!doneSync) {
                    if (this.breadcrumbId != null) {
                        MDC.put(MDCUnitOfWork.MDC_BREADCRUMB_ID, this.breadcrumbId);
                    }
                    if (this.exchangeId != null) {
                        MDC.put(MDCUnitOfWork.MDC_EXCHANGE_ID, this.exchangeId);
                    }
                    if (this.messageId != null) {
                        MDC.put(MDCUnitOfWork.MDC_MESSAGE_ID, this.messageId);
                    }
                    if (this.correlationId != null) {
                        MDC.put(MDCUnitOfWork.MDC_CORRELATION_ID, this.correlationId);
                    }
                    if (this.routeId != null) {
                        MDC.put(MDCUnitOfWork.MDC_ROUTE_ID, this.routeId);
                    }
                    if (this.camelContextId != null) {
                        MDC.put(MDCUnitOfWork.MDC_CAMEL_CONTEXT_ID, this.camelContextId);
                    }
                }
            }
            finally {
                this.delegate.done(doneSync);
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

