/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import javax.net.SocketFactory;
import org.apache.activemq.transport.nio.NIOOutputStream;
import org.apache.activemq.transport.nio.SelectorManager;
import org.apache.activemq.transport.nio.SelectorSelection;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;

public class StompNIOTransport
extends TcpTransport {
    private SocketChannel channel;
    private SelectorSelection selection;
    private ByteBuffer inputBuffer;
    ByteArrayOutputStream currentCommand = new ByteArrayOutputStream();
    boolean processedHeaders = false;
    String action;
    HashMap<String, String> headers;
    int contentLength = -1;
    int readLength = 0;
    int previousByte = -1;

    public StompNIOTransport(WireFormat wireFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(wireFormat, socketFactory, remoteLocation, localLocation);
    }

    public StompNIOTransport(WireFormat wireFormat, Socket socket) throws IOException {
        super(wireFormat, socket);
    }

    @Override
    protected void initializeStreams() throws IOException {
        this.channel = this.socket.getChannel();
        this.channel.configureBlocking(false);
        this.selection = SelectorManager.getInstance().register(this.channel, new SelectorManager.Listener(){

            @Override
            public void onSelect(SelectorSelection selection) {
                StompNIOTransport.this.serviceRead();
            }

            @Override
            public void onError(SelectorSelection selection, Throwable error) {
                if (error instanceof IOException) {
                    StompNIOTransport.this.onException((IOException)error);
                } else {
                    StompNIOTransport.this.onException(IOExceptionSupport.create(error));
                }
            }
        });
        this.inputBuffer = ByteBuffer.allocate(8192);
        NIOOutputStream outPutStream = new NIOOutputStream(this.channel, 8192);
        this.dataOut = new DataOutputStream(outPutStream);
        this.buffOut = outPutStream;
    }

    private void serviceRead() {
        try {
            while (true) {
                int readSize;
                if ((readSize = this.channel.read(this.inputBuffer)) == -1) {
                    this.onException(new EOFException());
                    this.selection.close();
                    break;
                }
                if (readSize == 0) break;
                this.inputBuffer.flip();
                ByteArrayInputStream input = new ByteArrayInputStream(this.inputBuffer.array());
                int i = 0;
                while (i++ < readSize) {
                    int b = input.read();
                    if (!this.processedHeaders && this.previousByte == 0 && b == 0) continue;
                    if (!this.processedHeaders) {
                        this.currentCommand.write(b);
                        StompWireFormat wf = (StompWireFormat)this.wireFormat;
                        if (this.previousByte == 10 && b == 10) {
                            if (this.wireFormat instanceof StompWireFormat) {
                                DataByteArrayInputStream data = new DataByteArrayInputStream(this.currentCommand.toByteArray());
                                this.action = wf.parseAction(data);
                                this.headers = wf.parseHeaders(data);
                                try {
                                    if (this.action.equals("CONNECT") || this.action.equals("STOMP")) {
                                        wf.setStompVersion(StompWireFormat.detectVersion(this.headers));
                                    }
                                    String contentLengthHeader = this.headers.get("content-length");
                                    this.contentLength = (this.action.equals("SEND") || this.action.equals("MESSAGE")) && contentLengthHeader != null ? wf.parseContentLength(contentLengthHeader) : -1;
                                }
                                catch (ProtocolException ignore) {
                                    // empty catch block
                                }
                            }
                            this.processedHeaders = true;
                            this.currentCommand.reset();
                        }
                    } else if (this.contentLength == -1) {
                        if (b == 0) {
                            this.processCommand();
                        } else {
                            this.currentCommand.write(b);
                        }
                    } else if (this.readLength++ == this.contentLength) {
                        this.processCommand();
                        this.readLength = 0;
                    } else {
                        this.currentCommand.write(b);
                    }
                    this.previousByte = b;
                }
                this.inputBuffer.clear();
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    private void processCommand() throws Exception {
        StompFrame frame = new StompFrame(this.action, this.headers, this.currentCommand.toByteArray());
        this.doConsume(frame);
        this.processedHeaders = false;
        this.currentCommand.reset();
        this.contentLength = -1;
    }

    @Override
    protected void doStart() throws Exception {
        this.connect();
        this.selection.setInterestOps(1);
        this.selection.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        try {
            if (this.selection != null) {
                this.selection.close();
            }
        }
        finally {
            super.doStop(stopper);
        }
    }
}

